/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.http.client;

import java.io.IOException;
import org.hawaiiframework.logging.http.HawaiiRequestResponseLogger;
import org.hawaiiframework.logging.http.client.HttpRequestLogging;
import org.hawaiiframework.logging.model.KibanaLogCallResultTypes;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.KibanaLogTypeNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LoggingClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingClientHttpRequestInterceptor.class);
    private final HawaiiRequestResponseLogger hawaiiRequestResponseLogger;

    public LoggingClientHttpRequestInterceptor(HawaiiRequestResponseLogger hawaiiLogger) {
        this.hawaiiRequestResponseLogger = hawaiiLogger;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse clientHttpResponse;
        try {
            if (HttpRequestLogging.isEnabled()) {
                this.hawaiiRequestResponseLogger.logRequest(request, body);
            }
            ClientHttpResponse response = execution.execute(request, body);
            if (HttpRequestLogging.isEnabled()) {
                this.hawaiiRequestResponseLogger.logResponse(response);
            }
            clientHttpResponse = response;
        }
        catch (IOException exception) {
            try {
                KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_STATUS, KibanaLogCallResultTypes.TIMEOUT);
                KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.CALL_END);
                LOGGER.info("Got IO exception during call, most likely a timeout from backend.", (Throwable)exception);
                throw exception;
                catch (Throwable throwable) {
                    KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_STATUS, KibanaLogCallResultTypes.FAILURE);
                    KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.CALL_END);
                    LOGGER.info("Got exception during call, most likely a configuration issue.", throwable);
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                KibanaLogFields.clear(KibanaLogFieldNames.CALL_STATUS, KibanaLogFieldNames.LOG_TYPE);
                throw throwable;
            }
        }
        KibanaLogFields.clear(KibanaLogFieldNames.CALL_STATUS, KibanaLogFieldNames.LOG_TYPE);
        return clientHttpResponse;
    }
}

