/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.http.client;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TransactionIdSupplierHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final String headerName;

    public TransactionIdSupplierHttpRequestInterceptor() {
        this("X-Hawaii-Tx-Id");
    }

    public TransactionIdSupplierHttpRequestInterceptor(String headerName) {
        this.headerName = headerName;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String txId = KibanaLogFields.get(KibanaLogFieldNames.TX_ID);
        if (StringUtils.isNotBlank((CharSequence)txId)) {
            request.getHeaders().add(this.headerName, txId);
        }
        return execution.execute(request, body);
    }
}

