/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.micrometer;

import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerTraceIdResponseFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerTraceIdResponseFilter.class);
    private final String headerName;
    private final Tracer tracer;

    public MicrometerTraceIdResponseFilter(String headerName, Tracer tracer) {
        this.headerName = Objects.toString(headerName, "traceid");
        this.tracer = tracer;
        LOGGER.info("Configured to use '{}'.", (Object)this.headerName);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String traceId = this.getTraceId();
        if (traceId != null) {
            this.addHeader(response, traceId);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getTraceId() {
        return MicrometerTraceIdResponseFilter.getTraceId(this.tracer.currentTraceContext());
    }

    private static String getTraceId(CurrentTraceContext currentTraceContext) {
        TraceContext context = currentTraceContext.context();
        return MicrometerTraceIdResponseFilter.getTraceId(context);
    }

    private static String getTraceId(TraceContext context) {
        if (context == null) {
            return null;
        }
        return context.traceId();
    }

    private void addHeader(HttpServletResponse response, String value) {
        if (!response.containsHeader(this.headerName)) {
            response.setHeader(this.headerName, value);
        }
    }
}

