/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.scheduled;

import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.RequestId;
import org.hawaiiframework.logging.model.TransactionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ScheduledAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledAspect.class);

    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object withTransactionId(ProceedingJoinPoint pjp) throws Throwable {
        try {
            UUID uuid = UUID.randomUUID();
            RequestId.set(uuid);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.REQUEST_ID, RequestId.get());
            TransactionId.set(uuid);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_ID, TransactionId.get());
            LOGGER.trace("Started scheduled task with tx id '{}'.", (Object)TransactionId.get());
            Object object = pjp.proceed();
            return object;
        }
        catch (Exception exception) {
            LOGGER.error("Caught error '{}'.", (Object)exception.getMessage(), (Object)exception);
            throw exception;
        }
        finally {
            RequestId.remove();
            TransactionId.remove();
            KibanaLogFields.clear();
        }
    }
}

