/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.sql;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.logging.model.KibanaLogCallResultTypes;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.sql.SqlStatementLogging;
import org.hawaiiframework.logging.util.IndentUtil;
import org.hawaiiframework.sql.OrderedQueryExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@ConditionalOnClass(value={QueryExecutionListener.class})
@Component
public class StatementLoggerQueryExecutionListener
implements OrderedQueryExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementLoggerQueryExecutionListener.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        if (SqlStatementLogging.isSuppressed()) {
            return;
        }
        QueryInfo queryInfo = queryInfoList.get(0);
        StringBuilder builder = new StringBuilder(128);
        builder.append(queryInfo.getQuery());
        boolean parameterHeaderAppended = false;
        for (List parameterSetOperations : queryInfo.getParametersList()) {
            for (ParameterSetOperation parameterSetOperation : parameterSetOperations) {
                if (!parameterHeaderAppended) {
                    builder.append(LINE_SEPARATOR).append(LINE_SEPARATOR).append("parameters:").append(LINE_SEPARATOR);
                    parameterHeaderAppended = true;
                }
                if (ParameterSetOperation.isSetNullParameterOperation((ParameterSetOperation)parameterSetOperation)) {
                    builder.append("null");
                } else {
                    Object[] args = parameterSetOperation.getArgs();
                    builder.append('\'').append(args[1]).append('\'');
                }
                builder.append(',').append(LINE_SEPARATOR);
            }
        }
        String value = builder.toString();
        if (value.endsWith("," + LINE_SEPARATOR)) {
            value = value.substring(0, value.length() - 1 - LINE_SEPARATOR.length());
        }
        KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_REQUEST_BODY, value);
        LOGGER.info("Executing query: {}{}", (Object)LINE_SEPARATOR, (Object)IndentUtil.indent(value));
        KibanaLogFields.clear((KibanaLogField)KibanaLogFieldNames.CALL_REQUEST_BODY);
    }

    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        if (SqlStatementLogging.isSuppressed()) {
            return;
        }
        if (execInfo.isSuccess()) {
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_STATUS, KibanaLogCallResultTypes.SUCCESS);
        } else {
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_STATUS, KibanaLogCallResultTypes.FAILURE);
            StatementLoggerQueryExecutionListener.logFailure(execInfo.getThrowable());
        }
        LOGGER.info("Execution of query took '{}' msec.", (Object)execInfo.getElapsedTime());
        KibanaLogFields.clear((KibanaLogField)KibanaLogFieldNames.CALL_STATUS);
    }

    private static void logFailure(Throwable throwable) {
        LOGGER.info("Query execution failed with error '{}'.", (Object)StringUtils.chomp((String)throwable.getMessage()));
    }

    public int getOrder() {
        return 0;
    }
}

