/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpRetryException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.logging.util.PasswordMaskerUtil;
import org.hawaiiframework.logging.web.util.ContentCachingWrappedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;

public class HttpRequestResponseBodyLogUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestResponseBodyLogUtil.class);
    private static final String NEW_LINE = System.lineSeparator();
    private final PasswordMaskerUtil passwordMasker;

    public HttpRequestResponseBodyLogUtil(PasswordMaskerUtil passwordMasker) {
        this.passwordMasker = passwordMasker;
    }

    public String getTxRequestBody(HttpServletRequest servletRequest) throws IOException {
        return this.maskPasswords(HttpRequestResponseBodyLogUtil.getPostBody(servletRequest));
    }

    public String getTxResponseBody(ContentCachingWrappedResponse servletResponse) {
        String characterEncoding = servletResponse.getCharacterEncoding();
        if ("application/json".equals(servletResponse.getContentType())) {
            characterEncoding = "UTF-8";
        }
        if (characterEncoding == null || characterEncoding.isEmpty()) {
            characterEncoding = Charset.defaultCharset().name();
        }
        return this.maskPasswords(HttpRequestResponseBodyLogUtil.toString(servletResponse.getContentAsByteArray(), characterEncoding));
    }

    public String getCallRequestBody(byte[] body) {
        return this.maskPasswords(HttpRequestResponseBodyLogUtil.toString(body, Charset.defaultCharset()));
    }

    public String getCallResponseBody(ClientHttpResponse response) throws IOException {
        StringBuilder inputStringBuilder = new StringBuilder();
        return this.maskPasswords(HttpRequestResponseBodyLogUtil.getResponseBody(inputStringBuilder, response));
    }

    private static String toString(byte[] body, String charset) {
        return HttpRequestResponseBodyLogUtil.toString(body, Charset.forName(charset));
    }

    private static String toString(byte[] body, Charset charset) {
        return new String(body, charset);
    }

    private static String getPostBody(HttpServletRequest servletRequest) throws IOException {
        String body = IOUtils.toString((InputStream)servletRequest.getInputStream(), (String)servletRequest.getCharacterEncoding());
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return body;
        }
        return HttpRequestResponseBodyLogUtil.getPostParametersBody(servletRequest);
    }

    private static String getPostParametersBody(HttpServletRequest request) {
        Map parameters = request.getParameterMap();
        return HttpRequestResponseBodyLogUtil.getPostParametersBody(request, parameters);
    }

    private static String getPostParametersBody(HttpServletRequest request, Map<String, String[]> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> parameterNames = new ArrayList<String>(parameters.keySet());
        Collections.sort(parameterNames);
        for (String parameterName : parameterNames) {
            String[] parameterValues = request.getParameterValues(parameterName);
            if (parameterValues == null) continue;
            for (String value : parameterValues) {
                stringBuilder.append(parameterName).append('=').append(value).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private static String getResponseBody(StringBuilder inputStringBuilder, ClientHttpResponse response) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(response.getBody(), StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                inputStringBuilder.append(line).append(NEW_LINE);
                line = bufferedReader.readLine();
            }
        }
        catch (HttpRetryException exception) {
            LOGGER.warn("Got retry exception.");
            LOGGER.trace("Stacktrace is: ", (Throwable)exception);
        }
        catch (IOException exception) {
            LOGGER.warn("Could not get response body.", (Throwable)exception);
        }
        return inputStringBuilder.toString();
    }

    private String maskPasswords(String input) {
        return this.passwordMasker.maskPasswordsIn(input);
    }
}

