/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.hawaiiframework.logging.util.PasswordMaskerUtil;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class HttpRequestResponseHeadersLogUtil {
    private static final String NEW_LINE = System.lineSeparator();
    private final PasswordMaskerUtil passwordMasker;

    public HttpRequestResponseHeadersLogUtil(PasswordMaskerUtil passwordMasker) {
        this.passwordMasker = passwordMasker;
    }

    public String getTxRequestHeaders(HttpServletRequest servletRequest) {
        HttpHeaders headers = HttpRequestResponseHeadersLogUtil.creatHttpHeaders(servletRequest);
        return this.createHeadersAsString(headers);
    }

    public String getTxResponseHeaders(HttpServletResponse servletResponse) {
        HttpHeaders headers = HttpRequestResponseHeadersLogUtil.creatHttpHeaders(servletResponse);
        return this.createHeadersAsString(headers);
    }

    private static HttpHeaders creatHttpHeaders(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration values = request.getHeaders(headerName);
            while (values.hasMoreElements()) {
                headers.add(headerName, (String)values.nextElement());
            }
        }
        return headers;
    }

    private static HttpHeaders creatHttpHeaders(HttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String headerName : response.getHeaderNames()) {
            for (String headerValue : response.getHeaders(headerName)) {
                headers.add(headerName, headerValue);
            }
        }
        return headers;
    }

    public String getCallRequestHeaders(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        return this.createHeadersAsString(headers);
    }

    public String getCallResponseHeaders(ClientHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        return this.createHeadersAsString(headers);
    }

    private String createHeadersAsString(HttpHeaders headers) {
        StringBuilder builder = new StringBuilder();
        HttpRequestResponseHeadersLogUtil.appendHeaders(builder, headers);
        String value = builder.toString();
        return this.passwordMasker.maskPasswordsIn(value);
    }

    private static void appendHeaders(StringBuilder builder, HttpHeaders headers) {
        ArrayList headerNames = new ArrayList(headers.keySet());
        Collections.sort(headerNames);
        for (String headerName : headerNames) {
            builder.append(headerName).append(": ").append(String.join((CharSequence)", ", headers.get((Object)headerName))).append(NEW_LINE);
        }
    }
}

