/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import org.hawaiiframework.logging.util.MaskedPasswordBuilder;
import org.hawaiiframework.logging.util.PasswordMasker;

public class JsonPasswordMasker
implements PasswordMasker {
    private static final Character JSON_ESCAPE = Character.valueOf('\\');
    private static final Character COLON = Character.valueOf(':');
    private static final Character QUOTE = Character.valueOf('\"');

    @Override
    public boolean matches(MaskedPasswordBuilder builder) {
        if (builder.currentCharIs(QUOTE)) {
            builder.mark();
            builder.next();
            if (JsonPasswordMasker.readUntilStartOfJsonValue(builder)) {
                int indexOfStartPassword = builder.getCurrentIndex();
                if (JsonPasswordMasker.readUntilEndOfJsonValue(builder)) {
                    builder.maskPasswordAt(indexOfStartPassword + 1);
                    return true;
                }
            }
            builder.reset();
        }
        return false;
    }

    private static boolean readUntilStartOfJsonValue(MaskedPasswordBuilder builder) {
        JsonPasswordMasker.readWhiteSpaces(builder);
        if (builder.currentCharIs(COLON)) {
            builder.next();
            JsonPasswordMasker.readWhiteSpaces(builder);
            return builder.currentCharIs(QUOTE);
        }
        return false;
    }

    private static boolean readUntilEndOfJsonValue(MaskedPasswordBuilder builder) {
        boolean escape = false;
        while (builder.hasNext()) {
            builder.next();
            if (!escape && builder.currentCharIs(QUOTE)) {
                return true;
            }
            escape = builder.currentCharIs(JSON_ESCAPE);
        }
        return false;
    }

    private static void readWhiteSpaces(MaskedPasswordBuilder builder) {
        while (builder.currentCharIsWhitespace() && builder.hasNext()) {
            builder.next();
        }
    }
}

