/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hawaiiframework.logging.util.JsonPasswordMasker;
import org.hawaiiframework.logging.util.MaskedPasswordBuilder;
import org.hawaiiframework.logging.util.PasswordMasker;
import org.hawaiiframework.logging.util.UriQueryStringPasswordMasker;
import org.hawaiiframework.logging.util.XmlAttributePasswordMasker;

public class PasswordMaskerUtil {
    private static final List<PasswordMasker> PASSWORD_MASKERS = new ArrayList<PasswordMasker>();
    private final Set<String> fieldsToMask = new HashSet<String>();

    public PasswordMaskerUtil(Collection<String> fieldsToMask) {
        if (fieldsToMask != null && !fieldsToMask.isEmpty()) {
            this.fieldsToMask.addAll(fieldsToMask);
        } else {
            this.fieldsToMask.add("password");
        }
    }

    public String maskPasswordsIn(String input) {
        String masked = input;
        for (String fieldToMask : this.fieldsToMask) {
            masked = PasswordMaskerUtil.maskPasswords(masked, fieldToMask);
        }
        return masked;
    }

    private static String maskPasswords(String input, String pattern) {
        MaskedPasswordBuilder builder = new MaskedPasswordBuilder(input, pattern);
        if (!builder.findNextPassword()) {
            return input;
        }
        builder.reset();
        return PasswordMaskerUtil.maskPasswords(builder);
    }

    private static String maskPasswords(MaskedPasswordBuilder builder) {
        block0: while (builder.findNextPassword()) {
            while (builder.hasNext()) {
                boolean fieldMasked = false;
                for (PasswordMasker masker : PASSWORD_MASKERS) {
                    fieldMasked = masker.matches(builder);
                }
                if (fieldMasked || builder.currentCharIsWhitespace()) continue block0;
                builder.next();
            }
        }
        return builder.build();
    }

    static {
        PASSWORD_MASKERS.add(new JsonPasswordMasker());
        PASSWORD_MASKERS.add(new XmlAttributePasswordMasker());
        PASSWORD_MASKERS.add(new UriQueryStringPasswordMasker());
    }
}

