/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import org.hawaiiframework.logging.util.MaskedPasswordBuilder;
import org.hawaiiframework.logging.util.PasswordMasker;

public class UriQueryStringPasswordMasker
implements PasswordMasker {
    private static final Character EQUALS = Character.valueOf('=');
    private static final Character AMPERSAND = Character.valueOf('&');
    private static final Character QUOTE = Character.valueOf('\"');
    private static final Character LT = Character.valueOf('<');
    private static final Character NEWLINE = Character.valueOf('\n');
    private static final Character CARRIAGE_RETURN = Character.valueOf('\r');

    @Override
    public boolean matches(MaskedPasswordBuilder builder) {
        if (builder.currentCharIs(EQUALS)) {
            int indexOfStartPassword = builder.getCurrentIndex();
            UriQueryStringPasswordMasker.readUntilEndOfQueryParameterValue(builder);
            builder.maskPasswordAt(indexOfStartPassword + 1);
            return true;
        }
        return false;
    }

    private static void readUntilEndOfQueryParameterValue(MaskedPasswordBuilder builder) {
        while (builder.hasNext() && !builder.currentCharIsOneOf(AMPERSAND, QUOTE, LT, NEWLINE, CARRIAGE_RETURN)) {
            builder.next();
        }
    }
}

