/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.hawaiiframework.logging.web.util.ContentCachingWrappedResponse;
import org.hawaiiframework.logging.web.util.ResettableHttpServletRequest;
import org.hawaiiframework.logging.web.util.WrappedHttpRequestResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class AbstractGenericFilterBean
extends OncePerRequestFilter {
    protected static final String WRAPPED_REQUEST_RESPONSE = WrappedHttpRequestResponse.class.getName();

    protected WrappedHttpRequestResponse getWrapped(HttpServletRequest httpServletRequest) {
        return (WrappedHttpRequestResponse)httpServletRequest.getAttribute(WRAPPED_REQUEST_RESPONSE);
    }

    protected WrappedHttpRequestResponse getWrapped(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        WrappedHttpRequestResponse wrapped = this.getWrapped(httpServletRequest);
        if (wrapped != null) {
            return wrapped;
        }
        ContentCachingWrappedResponse wrappedResponse = new ContentCachingWrappedResponse(httpServletResponse);
        ResettableHttpServletRequest wrappedRequest = new ResettableHttpServletRequest(httpServletRequest, (HttpServletResponse)wrappedResponse);
        wrapped = new WrappedHttpRequestResponse(wrappedRequest, wrappedResponse);
        httpServletRequest.setAttribute(WRAPPED_REQUEST_RESPONSE, (Object)wrapped);
        return wrapped;
    }
}

