/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import org.hawaiiframework.logging.model.BusinessTransactionId;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.util.UuidResolver;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessTransactionIdFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessTransactionIdFilter.class);
    private final String headerName;
    private final UuidResolver uuidResolver = new UuidResolver();

    public BusinessTransactionIdFilter(String headerName) {
        this.headerName = headerName;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        UUID uuid = this.uuidResolver.resolve(request, this.headerName);
        BusinessTransactionId.set(uuid);
        KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.BUSINESS_TX_ID, BusinessTransactionId.get());
        LOGGER.debug("Set '{}' with value '{};.", (Object)KibanaLogFieldNames.BUSINESS_TX_ID.getLogName(), (Object)uuid);
        if (!response.containsHeader(this.headerName)) {
            response.addHeader(this.headerName, BusinessTransactionId.get());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

