/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.util.ClientIpResolver;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIpLogFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientIpLogFilter.class);
    private final ClientIpResolver clientIpResolver;

    public ClientIpLogFilter(ClientIpResolver clientIpResolver) {
        this.clientIpResolver = clientIpResolver;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String clientIp = this.clientIpResolver.getClientIp(request);
        KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_REQUEST_IP, clientIp);
        LOGGER.debug("Client ip is '{}'.", (Object)clientIp);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

