/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.hawaiiframework.logging.web.util.ContentCachingWrappedResponse;
import org.hawaiiframework.logging.web.util.ResettableHttpServletRequest;
import org.hawaiiframework.logging.web.util.WrappedHttpRequestResponse;

public class ContentCachingRequestResponseFilter
extends AbstractGenericFilterBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        WrappedHttpRequestResponse wrapped = this.getWrapped(httpServletRequest, httpServletResponse);
        try {
            filterChain.doFilter((ServletRequest)wrapped.request(), (ServletResponse)wrapped.response());
        }
        finally {
            ContentCachingRequestResponseFilter.copyCachedResponse(wrapped);
        }
    }

    private static void copyCachedResponse(WrappedHttpRequestResponse wrapped) throws IOException {
        ContentCachingWrappedResponse response;
        ResettableHttpServletRequest request;
        if (wrapped != null && !(request = wrapped.request()).isAsyncStarted() && (response = wrapped.response()) != null) {
            response.copyBodyToResponse();
        }
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }
}

