/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.config.FilterVoter;
import org.hawaiiframework.logging.model.AutoCloseableKibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.KibanaLogTypeNames;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDurationFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestDurationFilter.class);
    private static final String START_TIMESTAMP = "start_timestamp";
    private final FilterVoter filterVoter;

    public RequestDurationFilter(FilterVoter filterVoter) {
        this.filterVoter = filterVoter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (request.getAttribute(START_TIMESTAMP) == null) {
            request.setAttribute(START_TIMESTAMP, (Object)System.nanoTime());
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.logEnd(request);
        }
    }

    private void logEnd(HttpServletRequest request) {
        if (!request.isAsyncStarted() && this.filterVoter.enabled(request)) {
            RequestDurationFilter.logEnd((Long)request.getAttribute(START_TIMESTAMP));
        }
    }

    private static void logEnd(Long start) {
        if (start == null) {
            LOGGER.info("Could not read start timestamp from request!");
            return;
        }
        try (AutoCloseableKibanaLogField endField = KibanaLogFields.tagCloseable((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.END);){
            String duration = String.format("%.2f", (double)(System.nanoTime() - start) / 1000000.0);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_DURATION, duration);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.REQUEST_DURATION, duration);
            LOGGER.info("Duration '{}' ms.", (Object)duration);
        }
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }
}

