/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.RequestId;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestIdFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestIdFilter.class);
    private final String headerName;

    public RequestIdFilter(String headerName) {
        this.headerName = headerName;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        UUID uuid = UUID.randomUUID();
        RequestId.set(uuid);
        KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.REQUEST_ID, RequestId.get());
        LOGGER.debug("Set '{}' with value '{};.", (Object)KibanaLogFieldNames.REQUEST_ID.getLogName(), (Object)uuid);
        if (!response.containsHeader(this.headerName)) {
            response.addHeader(this.headerName, RequestId.get());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

