/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.config.FilterVoter;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.info.BuildProperties;

public class SoftwareVersionLogFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftwareVersionLogFilter.class);
    private final BuildProperties buildProperties;
    private final FilterVoter filterVoter;

    public SoftwareVersionLogFilter(BuildProperties buildProperties, FilterVoter filterVoter) {
        this.buildProperties = buildProperties;
        this.filterVoter = filterVoter;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.filterVoter.enabled(request)) {
            String version = this.buildProperties.getVersion();
            LOGGER.info("Software Build version '{}'.", (Object)version);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.SOFTWARE_VERSION, version);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

