/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.util;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class ContentCachingWrappedResponse
extends ContentCachingResponseWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentCachingWrappedResponse.class);
    private boolean redirect;
    private boolean streaming;

    public ContentCachingWrappedResponse(HttpServletResponse response) {
        super(response);
    }

    public void sendError(int statusCode) throws IOException {
        this.redirect = true;
        super.sendError(statusCode);
    }

    public void sendError(int statusCode, String message) throws IOException {
        this.redirect = true;
        super.sendError(statusCode, message);
    }

    public void sendRedirect(String location) throws IOException {
        this.redirect = true;
        super.sendRedirect(location);
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        if (ContentCachingWrappedResponse.isTextEventStreamHeader(name, value)) {
            LOGGER.debug("Triggered streaming for this content-caching response.");
            this.streaming = true;
        }
    }

    private static boolean isTextEventStreamHeader(String name, String value) {
        return "Content-Type".equals(name) && MediaType.TEXT_EVENT_STREAM.equals((Object)MediaType.valueOf((String)value));
    }

    public void flushBuffer() throws IOException {
        if (this.streaming) {
            this.copyBodyToResponse(false);
            this.getResponse().flushBuffer();
        }
    }
}

