/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.util;

import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.parser.Parser;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.hawaiiframework.logging.web.util.ResettableHttpServletRequest;
import org.hawaiiframework.logging.web.util.TransactionTypeSupplier;
import org.json.JSONObject;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;

@Order(value=0)
public class GraphQlTransactionTypeSupplier
implements TransactionTypeSupplier {
    private static final String GRAPHQL_URL_IDENTIFIER = "graphql";

    private static String getPostBody(HttpServletRequest servletRequest) throws IOException {
        return IOUtils.toString((InputStream)servletRequest.getInputStream(), (String)servletRequest.getCharacterEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTransactionType(ResettableHttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        if (contentType == null || !request.getServletPath().contains(GRAPHQL_URL_IDENTIFIER)) {
            return null;
        }
        try {
            if (MediaType.MULTIPART_FORM_DATA.includes(MediaType.parseMediaType((String)contentType))) {
                String string = "Graphql.multiPart";
                return string;
            }
            String body = GraphQlTransactionTypeSupplier.getPostBody((HttpServletRequest)request);
            JSONObject jsonObject = new JSONObject(body);
            String query = jsonObject.getString("query");
            Document document = Parser.parse((String)query);
            OperationDefinition operationDefinition = (OperationDefinition)document.getDefinitionsOfType(OperationDefinition.class).get(0);
            String operation = operationDefinition.getOperation().name().toLowerCase(Locale.getDefault());
            String action = ((Field)operationDefinition.getSelectionSet().getSelectionsOfType(Field.class).get(0)).getName();
            String string = "Graphql." + operation + "." + action;
            return string;
        }
        finally {
            request.reset();
        }
    }
}

