/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.security.oauth2.config;

import org.hawaiiframework.cache.Cache;
import org.hawaiiframework.security.oauth2.provider.token.HawaiiTokenServices;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;

@EnableWebSecurity
@EnableResourceServer
@Deprecated
public class HawaiiResourceServerConfigurerAdapter
extends ResourceServerConfigurerAdapter {
    @Bean
    public TokenStore jwkTokenStore(ResourceServerProperties properties) {
        DefaultAccessTokenConverter accessTokenConverter = new DefaultAccessTokenConverter();
        accessTokenConverter.setUserTokenConverter((UserAuthenticationConverter)new DefaultUserAuthenticationConverter());
        return new JwkTokenStore(this.resolveJwkSetUri(properties.getJwk()), (AccessTokenConverter)accessTokenConverter);
    }

    private String resolveJwkSetUri(ResourceServerProperties.Jwk jwk) {
        return jwk.getKeySetUri();
    }

    @Bean
    @Primary
    public OAuth2RestOperations oAuth2RestOperations(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext clientContext) {
        return new OAuth2RestTemplate(resource, clientContext);
    }

    @Bean
    public ResourceServerTokenServices resourceServerTokenServices(TokenStore jwkTokenStore, OAuth2RestOperations restTemplate, ResourceServerProperties properties, PrincipalExtractor principalExtractor, Cache<Authentication> authenticationCache) {
        DefaultTokenServices defaultTokenServices = new DefaultTokenServices();
        defaultTokenServices.setTokenStore(jwkTokenStore);
        UserInfoTokenServices userInfoTokenServices = new UserInfoTokenServices(properties.getUserInfoUri(), properties.getClientId());
        userInfoTokenServices.setRestTemplate(restTemplate);
        userInfoTokenServices.setTokenType(properties.getTokenType());
        userInfoTokenServices.setPrincipalExtractor(principalExtractor);
        return new HawaiiTokenServices(defaultTokenServices, userInfoTokenServices, authenticationCache);
    }
}

