/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.security.oauth2.provider.token;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;

public class HawaiiTokenServices
implements ResourceServerTokenServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(HawaiiTokenServices.class);
    private final DefaultTokenServices defaultTokenServices;
    private final UserInfoTokenServices userInfoTokenServices;
    private final Cache<Authentication> cache;

    public HawaiiTokenServices(DefaultTokenServices defaultTokenServices, UserInfoTokenServices userInfoTokenServices, Cache<Authentication> cache) {
        this.defaultTokenServices = defaultTokenServices;
        this.userInfoTokenServices = userInfoTokenServices;
        this.cache = cache;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        OAuth2Authentication jwkAuthentication = this.defaultTokenServices.loadAuthentication(accessToken);
        OAuth2Request request = this.extractOAuth2Request(jwkAuthentication);
        OAuth2AccessToken token = this.readAccessToken(accessToken);
        String jti = this.getJti(token);
        Authentication userAuthentication = (Authentication)this.cache.get(jti);
        if (userAuthentication == null) {
            LOGGER.info("UserAuthentication not found in cache, retrieving it from SSO");
            OAuth2Authentication userInfoAuthentication = this.userInfoTokenServices.loadAuthentication(accessToken);
            userAuthentication = this.extractUserAuthentication(userInfoAuthentication);
            this.cache.put(jti, (Object)userAuthentication, Duration.of(token.getExpiresIn(), ChronoUnit.SECONDS));
        } else {
            LOGGER.info("UserAuthentication found in cache");
        }
        return new OAuth2Authentication(request, userAuthentication);
    }

    private OAuth2Request extractOAuth2Request(OAuth2Authentication authentication) {
        return authentication.getOAuth2Request();
    }

    private Authentication extractUserAuthentication(OAuth2Authentication authentication) {
        return authentication.getUserAuthentication();
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        return this.defaultTokenServices.readAccessToken(accessToken);
    }

    private String getJti(OAuth2AccessToken accessToken) {
        Map additionalInformation = accessToken.getAdditionalInformation();
        return this.getJti(additionalInformation);
    }

    private String getJti(Map<String, Object> additionalInformation) {
        String jti = (String)additionalInformation.get("jti");
        if (StringUtils.isBlank((CharSequence)jti)) {
            throw new InvalidTokenException("Access token has no jti");
        }
        return jti;
    }
}

