/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Role;
import org.hawkular.accounts.api.model.Role_;

@Stateless
@PermitAll
public class RoleServiceImpl
implements RoleService {
    @Inject
    @HawkularAccounts
    EntityManager em;

    @Override
    public Role getByName(String name) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Role.class);
        Root root = query.from(Role.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Role_.name), (Object)name));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            Role role = (Role)results.get(0);
            return role;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one role found for name " + name);
        }
        return null;
    }

    @Override
    public Set<Role> getImplicitUserRoles(String name) {
        HashSet<Role> implicitRoles = new HashSet<Role>(7);
        switch (name) {
            case "SuperUser": {
                implicitRoles.add(this.getByName("Auditor"));
                implicitRoles.add(this.getByName("Administrator"));
                implicitRoles.add(this.getByName("Deployer"));
            }
            case "Deployer": 
            case "Administrator": {
                implicitRoles.add(this.getByName("Maintainer"));
            }
            case "Maintainer": {
                implicitRoles.add(this.getByName("Operator"));
            }
            case "Auditor": 
            case "Operator": {
                implicitRoles.add(this.getByName("Monitor"));
            }
            case "Monitor": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized role: '" + name + "'");
            }
        }
        return implicitRoles;
    }

    @Override
    public Set<Role> getImplicitPermittedRoles(String name) {
        HashSet<Role> implicitRoles = new HashSet<Role>(7);
        switch (name) {
            case "Monitor": {
                implicitRoles.add(this.getByName("Operator"));
                implicitRoles.add(this.getByName("Auditor"));
            }
            case "Operator": {
                implicitRoles.add(this.getByName("Maintainer"));
            }
            case "Maintainer": {
                implicitRoles.add(this.getByName("Administrator"));
                implicitRoles.add(this.getByName("Deployer"));
            }
            case "Deployer": 
            case "Administrator": 
            case "Auditor": {
                implicitRoles.add(this.getByName("SuperUser"));
            }
            case "SuperUser": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized role: '" + name + "'");
            }
        }
        return implicitRoles;
    }

    @Override
    public Set<Role> getImplicitUserRoles(Role role) {
        return this.getImplicitUserRoles(role.getName());
    }

    @Override
    public Set<Role> getImplicitPermittedRoles(Role role) {
        return this.getImplicitPermittedRoles(role.getName());
    }

    @Override
    @Produces
    @NamedRole
    public Role produceRoleByName(InjectionPoint injectionPoint) {
        NamedRole namedRole = (NamedRole)injectionPoint.getAnnotated().getAnnotation(NamedRole.class);
        String roleName = namedRole.value();
        return this.getByName(roleName);
    }
}

