/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.HawkularUser_;
import org.keycloak.KeycloakPrincipal;

@Stateless
@PermitAll
public class UserServiceImpl
implements UserService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Resource
    SessionContext sessionContext;

    @Override
    @Produces
    @CurrentUser
    public HawkularUser getCurrent() {
        HawkularUser user;
        KeycloakPrincipal principal = (KeycloakPrincipal)this.sessionContext.getCallerPrincipal();
        String id = principal.getName();
        String name = principal.getKeycloakSecurityContext().getToken().getName();
        if (!name.equals((user = this.getOrCreateByIdAndName(id, name)).getName())) {
            user.setName(name);
            this.em.persist((Object)user);
        }
        return user;
    }

    @Override
    public HawkularUser getById(String id) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(HawkularUser.class);
        Root root = query.from(HawkularUser.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(HawkularUser_.id), (Object)id));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (HawkularUser)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one persona found for ID " + id);
        }
        return null;
    }

    @Override
    public HawkularUser getOrCreateById(String id) {
        HawkularUser user = this.getById(id);
        if (null == user) {
            user = new HawkularUser(id);
            this.em.persist((Object)user);
        }
        return user;
    }

    @Override
    public HawkularUser getOrCreateByIdAndName(String id, String name) {
        HawkularUser user = this.getById(id);
        if (null == user) {
            user = new HawkularUser(id);
            user.setName(name);
            this.em.persist((Object)user);
        }
        return user;
    }
}

