/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Role;

@Entity
public class Invitation
extends BaseEntity {
    private String email;
    private ZonedDateTime acceptedAt = null;
    private ZonedDateTime dispatchedAt = null;
    @Column(unique=true)
    private final String token = UUID.randomUUID().toString();
    @ManyToOne
    private HawkularUser invitedBy;
    @ManyToOne
    private HawkularUser acceptedBy;
    @ManyToOne
    private Organization organization;
    @ManyToOne
    private Role role;

    protected Invitation() {
    }

    public Invitation(String email, HawkularUser invitedBy, Organization organization, Role role) {
        this.email = email;
        this.invitedBy = invitedBy;
        this.organization = organization;
        this.role = role;
    }

    public Invitation(String id, String email, HawkularUser invitedBy, Organization organization, Role role) {
        super(id);
        this.email = email;
        this.invitedBy = invitedBy;
        this.organization = organization;
        this.role = role;
    }

    public String getToken() {
        return this.token;
    }

    public HawkularUser getInvitedBy() {
        return this.invitedBy;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Role getRole() {
        return this.role;
    }

    public String getEmail() {
        return this.email;
    }

    public ZonedDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    public void setAcceptedAt(ZonedDateTime acceptedAt) {
        this.acceptedAt = acceptedAt;
    }

    public ZonedDateTime getDispatchedAt() {
        return this.dispatchedAt;
    }

    public void setDispatchedAt(ZonedDateTime dispatchedAt) {
        this.dispatchedAt = dispatchedAt;
    }

    public void setAccepted() {
        this.acceptedAt = ZonedDateTime.now();
    }

    public void setDispatched() {
        this.dispatchedAt = ZonedDateTime.now();
    }

    public HawkularUser getAcceptedBy() {
        return this.acceptedBy;
    }

    public void setAcceptedBy(HawkularUser acceptedBy) {
        this.acceptedBy = acceptedBy;
    }
}

