/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.OrganizationMembership_;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OrganizationMembershipServiceImpl
implements OrganizationMembershipService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    ResourceService resourceService;
    @Inject
    PersonaService personaService;

    @Override
    public OrganizationMembership create(Organization organization, Persona persona, Role role) {
        OrganizationMembership membership = new OrganizationMembership(organization, persona, role);
        this.em.persist((Object)membership);
        Resource resource = this.resourceService.get(organization.getId());
        this.resourceService.addRoleToPersona(resource, persona, role);
        return membership;
    }

    @Override
    public List<OrganizationMembership> getMembershipsForPersona(Persona persona) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationMembership.class);
        Root root = query.from(OrganizationMembership.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(OrganizationMembership_.member), (Object)persona));
        return this.em.createQuery(query).getResultList();
    }

    @Override
    public List<OrganizationMembership> getMembershipsForOrganization(Organization organization) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationMembership.class);
        Root root = query.from(OrganizationMembership.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(OrganizationMembership_.organization), (Object)organization));
        return this.em.createQuery(query).getResultList();
    }

    @Override
    public List<OrganizationMembership> getPersonaMembershipsForOrganization(Persona persona, Organization organization) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationMembership.class);
        Root root = query.from(OrganizationMembership.class);
        query.select((Selection)root);
        query.where(new Predicate[]{builder.equal((Expression)root.get(OrganizationMembership_.organization), (Object)organization), builder.equal((Expression)root.get(OrganizationMembership_.member), (Object)persona)});
        return this.em.createQuery(query).getResultList();
    }

    @Override
    public OrganizationMembership getMembershipById(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The given membership ID is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationMembership.class);
        Root root = query.from(OrganizationMembership.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(OrganizationMembership_.id), (Object)id));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (OrganizationMembership)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one membership found for ID " + id);
        }
        return null;
    }

    @Override
    public OrganizationMembership changeRole(OrganizationMembership membership, Role role) {
        membership.setRole(role);
        this.em.persist((Object)membership);
        Persona persona = this.personaService.get(membership.getMember().getId());
        Resource resource = this.resourceService.get(membership.getOrganization().getId());
        this.resourceService.revokeAllForPersona(resource, persona);
        this.resourceService.addRoleToPersona(resource, persona, role);
        return membership;
    }
}

