/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Organization_;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OrganizationServiceImpl
implements OrganizationService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    ResourceService resourceService;
    @Inject
    InvitationService invitationService;
    @Inject
    @NamedRole(value="SuperUser")
    Role superUser;

    @Override
    public List<Organization> getOrganizationsForPersona(Persona persona) {
        return this.getOrganizationsFromMemberships(this.membershipService.getMembershipsForPersona(persona));
    }

    @Override
    public List<Organization> getOrganizationsFromMemberships(List<OrganizationMembership> memberships) {
        return memberships.stream().map(OrganizationMembership::getOrganization).distinct().collect(Collectors.toList());
    }

    @Override
    public Organization createOrganization(String name, String description, Persona owner) {
        Organization organization = new Organization(owner);
        organization.setName(name);
        organization.setDescription(description);
        Resource resource = this.resourceService.create(organization.getId(), owner);
        this.resourceService.addRoleToPersona(resource, owner, this.superUser);
        this.em.persist((Object)organization);
        this.em.persist((Object)new OrganizationMembership(organization, owner, this.superUser));
        return organization;
    }

    @Override
    public void deleteOrganization(Organization organization) {
        Resource resource = this.resourceService.get(organization.getId());
        this.invitationService.getInvitationsForOrganization(organization).stream().forEach(invitation -> {
            if (null != invitation.getAcceptedBy()) {
                this.resourceService.revokeAllForPersona(resource, invitation.getAcceptedBy());
            }
            this.em.remove(invitation);
        });
        this.membershipService.getMembershipsForOrganization(organization).stream().forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0));
        this.resourceService.revokeAllForPersona(resource, organization.getOwner());
        this.resourceService.delete(organization.getId());
        this.em.remove((Object)organization);
    }

    @Override
    public void transfer(Organization organization, Persona newOwner) {
        this.membershipService.getPersonaMembershipsForOrganization(newOwner, organization).stream().forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0));
        this.em.persist((Object)new OrganizationMembership(organization, newOwner, this.superUser));
        Resource resource = this.resourceService.get(organization.getId());
        this.resourceService.transfer(resource, newOwner);
        organization.setOwner(newOwner);
        this.em.persist((Object)organization);
    }

    @Override
    public Organization get(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The given organization ID is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Organization.class);
        Root root = query.from(Organization.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Organization_.id), (Object)id));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (Organization)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one organization found for ID " + id);
        }
        return null;
    }

    @Override
    public List<Organization> getSubOrganizations(Organization organization) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Organization.class);
        Root root = query.from(Organization.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Organization_.owner), (Object)organization));
        return this.em.createQuery(query).getResultList();
    }
}

