/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.PersonaResourceRole;
import org.hawkular.accounts.api.model.PersonaResourceRole_;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Resource_;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class ResourceServiceImpl
implements ResourceService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    Persona persona;
    @Inject
    @NamedRole(value="SuperUser")
    Role superUser;

    @Override
    public Resource get(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The given resource ID is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Resource.class);
        Root root = query.from(Resource.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Resource_.id), (Object)id));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (Resource)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one resource found for ID " + id);
        }
        return null;
    }

    @Override
    public Resource create(String id, Persona persona) {
        if (null == persona) {
            throw new IllegalArgumentException("The specified persona is invalid (null).");
        }
        return this.create(id, null, persona);
    }

    @Override
    public Resource create(String id, Resource parent) {
        if (null == parent) {
            throw new IllegalArgumentException("The given parent resource is invalid (null).");
        }
        return this.create(id, parent, null);
    }

    @Override
    public Resource create(String id, Resource parent, Persona persona) {
        if (null == parent && null == persona) {
            throw new IllegalArgumentException("Either parent or persona should be provided when creating a resource");
        }
        Resource resource = new Resource(id, persona, parent);
        this.em.persist((Object)resource);
        if (persona != null) {
            PersonaResourceRole resourceRole = new PersonaResourceRole(persona, this.superUser, resource);
            this.em.persist((Object)resourceRole);
        }
        return resource;
    }

    @Override
    public void delete(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The given resource ID is invalid (null).");
        }
        Resource resource = this.get(id);
        if (resource != null) {
            this.em.remove((Object)resource);
        }
    }

    @Override
    public List<Resource> getByPersona(Persona persona) {
        if (null == persona) {
            throw new IllegalArgumentException("The given persona is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Resource.class);
        Root root = query.from(Resource.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Resource_.persona), (Object)persona));
        return this.em.createQuery(query).getResultList();
    }

    @Override
    public void transfer(Resource resource, Persona persona) {
        resource.setPersona(persona);
        this.em.persist((Object)resource);
        this.revokeAllForPersona(resource, persona);
        this.addRoleToPersona(resource, persona, this.superUser);
    }

    @Override
    public void revokeAllForPersona(Resource resource, Persona persona) {
        List<PersonaResourceRole> results = this.getRolesForPersona(resource, persona);
        results.stream().forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0));
    }

    @Override
    public PersonaResourceRole addRoleToPersona(Resource resource, Persona persona, Role role) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(PersonaResourceRole.class);
        Root root = query.from(PersonaResourceRole.class);
        query.select((Selection)root);
        query.where(new Predicate[]{builder.equal((Expression)root.get(PersonaResourceRole_.resource), (Object)resource), builder.equal((Expression)root.get(PersonaResourceRole_.persona), (Object)persona), builder.equal((Expression)root.get(PersonaResourceRole_.role), (Object)role)});
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (PersonaResourceRole)results.get(0);
        }
        PersonaResourceRole resourceRole = new PersonaResourceRole(persona, role, resource);
        this.em.persist((Object)resourceRole);
        return resourceRole;
    }

    @Override
    public List<PersonaResourceRole> getRolesForPersona(Resource resource, Persona persona) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(PersonaResourceRole.class);
        Root root = query.from(PersonaResourceRole.class);
        query.select((Selection)root);
        query.where(new Predicate[]{builder.equal((Expression)root.get(PersonaResourceRole_.resource), (Object)resource), builder.equal((Expression)root.get(PersonaResourceRole_.persona), (Object)persona)});
        return this.em.createQuery(query).getResultList();
    }
}

