/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.NamedSetting;
import org.hawkular.accounts.api.UserSettingsService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.UserSettings;
import org.hawkular.accounts.api.model.UserSettings_;

@Stateless
@PermitAll
public class UserSettingsServiceImpl
implements UserSettingsService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    @CurrentUser
    HawkularUser user;

    @Override
    public UserSettings get(String id) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(UserSettings.class);
        Root root = query.from(UserSettings.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(UserSettings_.id), (Object)id));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            UserSettings settings = (UserSettings)results.get(0);
            return settings;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one settings object found for ID " + id);
        }
        return null;
    }

    @Override
    public UserSettings getByUser() {
        return this.getByUser(this.user);
    }

    @Override
    public UserSettings getByUser(HawkularUser user) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(UserSettings.class);
        Root root = query.from(UserSettings.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(UserSettings_.user), (Object)user));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            UserSettings settings = (UserSettings)results.get(0);
            return settings;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one settings object found for user " + user.getId());
        }
        return null;
    }

    @Override
    public UserSettings getOrCreateByUser() {
        return this.getOrCreateByUser(this.user);
    }

    @Override
    public UserSettings getOrCreateByUser(HawkularUser user) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            settings = new UserSettings(user);
            this.em.persist((Object)settings);
        }
        return settings;
    }

    @Override
    public String getSettingByKey(String key) {
        return this.getSettingByKey(this.user, key);
    }

    @Override
    public String getSettingByKey(String key, String defaultValue) {
        return this.getSettingByKey(this.user, key, defaultValue);
    }

    @Override
    public String getSettingByKey(HawkularUser user, String key) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            return null;
        }
        return settings.get(key);
    }

    @Override
    public String getSettingByKey(HawkularUser user, String key, String defaultValue) {
        String value = this.getSettingByKey(user, key);
        return value == null ? defaultValue : value;
    }

    @Override
    public UserSettings store(HawkularUser user, String key, String value) {
        UserSettings settings = this.getOrCreateByUser(user);
        settings.put(key, value);
        this.em.persist((Object)settings);
        return settings;
    }

    @Override
    public UserSettings store(String key, String value) {
        return this.store(this.user, key, value);
    }

    @Override
    public UserSettings remove(HawkularUser user, String key) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            return null;
        }
        settings.remove(key);
        this.em.persist((Object)settings);
        return settings;
    }

    @Override
    public UserSettings remove(String key) {
        return this.remove(this.user, key);
    }

    @Override
    @Produces
    @NamedSetting
    public String produceSettingByName(InjectionPoint injectionPoint) {
        NamedSetting namedSetting = (NamedSetting)injectionPoint.getAnnotated().getAnnotation(NamedSetting.class);
        String setting = namedSetting.value();
        return this.getSettingByKey(setting);
    }
}

