/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.HawkularUser;

@Entity
public class UserSettings
extends BaseEntity {
    @ManyToOne
    private HawkularUser user;
    @ElementCollection(fetch=FetchType.EAGER)
    private Map<String, String> properties = new HashMap<String, String>();

    protected UserSettings() {
    }

    public UserSettings(HawkularUser user) {
        this.user = user;
    }

    public UserSettings(HawkularUser user, Map<String, String> properties) {
        this.user = user;
        this.properties.putAll(properties);
    }

    public HawkularUser getUser() {
        return this.user;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean containsKey(String o) {
        return this.properties.containsKey(o);
    }

    public boolean containsValue(String o) {
        return this.properties.containsValue(o);
    }

    public String get(String o) {
        return this.properties.get(o);
    }

    public String put(String s, String s2) {
        return this.properties.put(s, s2);
    }

    public String remove(String o) {
        return this.properties.remove(o);
    }

    public void putAll(Map<? extends String, ? extends String> map) {
        this.properties.putAll(map);
    }

    public void clear() {
        this.properties.clear();
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    public Collection<String> values() {
        return this.properties.values();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.properties.entrySet();
    }

    public void replaceAll(BiFunction<? super String, ? super String, ? extends String> function) {
        this.properties.replaceAll(function);
    }

    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.properties.forEach(action);
    }

    public String getOrDefault(String key, String defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public String putIfAbsent(String key, String value) {
        return this.properties.putIfAbsent(key, value);
    }

    public boolean remove(String key, String value) {
        return this.properties.remove(key, value);
    }

    public boolean replace(String key, String oldValue, String newValue) {
        return this.properties.replace(key, oldValue, newValue);
    }

    public String replace(String key, String value) {
        return this.properties.replace(key, value);
    }

    public String computeIfAbsent(String key, Function<? super String, ? extends String> mappingFunction) {
        return this.properties.computeIfAbsent(key, mappingFunction);
    }

    public String computeIfPresent(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return this.properties.computeIfPresent(key, remappingFunction);
    }

    public String compute(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return this.properties.compute(key, remappingFunction);
    }

    public String merge(String key, String value, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        return this.properties.merge(key, value, remappingFunction);
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

