/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.OrganizationMembership_;
import org.hawkular.accounts.api.model.Persona;

@Stateless
@PermitAll
public class OrganizationMembershipServiceImpl
implements OrganizationMembershipService {
    @Inject
    @HawkularAccounts
    EntityManager em;

    @Override
    public List<OrganizationMembership> getMembershipsForPersona(Persona persona) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationMembership.class);
        Root root = query.from(OrganizationMembership.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(OrganizationMembership_.member), (Object)persona));
        return this.em.createQuery(query).getResultList();
    }

    @Override
    public List<OrganizationMembership> getMembershipsForOrganization(Organization organization) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationMembership.class);
        Root root = query.from(OrganizationMembership.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(OrganizationMembership_.organization), (Object)organization));
        return this.em.createQuery(query).getResultList();
    }
}

