/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.PermissionService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Permission;
import org.hawkular.accounts.api.model.Permission_;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PermissionServiceImpl
implements PermissionService {
    @Inject
    @HawkularAccounts
    EntityManager em;

    @Override
    public Set<Role> getPermittedRoles(Operation operation) {
        return this.getPermissionsForOperation(operation).stream().map(Permission::getRole).collect(Collectors.toSet());
    }

    @Override
    public Set<Permission> getPermissionsForOperation(Operation operation) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Permission.class);
        Root root = query.from(Permission.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Permission_.operation), (Object)operation));
        return this.em.createQuery(query).getResultList().stream().collect(Collectors.toSet());
    }
}

