/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.PreUpdate;

@MappedSuperclass
public class BaseEntity
implements Serializable {
    @Id
    private String id = UUID.randomUUID().toString();
    private final ZonedDateTime createdAt = ZonedDateTime.now();
    private ZonedDateTime updatedAt = ZonedDateTime.now();

    protected BaseEntity() {
    }

    public BaseEntity(String id) {
        if (null != id) {
            this.id = id;
        }
    }

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @PreUpdate
    public void setUpdatedAt() {
        this.updatedAt = ZonedDateTime.now();
    }

    public String toString() {
        return "BaseEntity{id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEntity other = (BaseEntity)obj;
        return Objects.equals(this.id, other.id);
    }
}

