/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.PermissionService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PermissionCheckerImpl
implements PermissionChecker {
    @Inject
    PermissionService permissionService;
    @Inject
    PersonaService personaService;
    @Inject
    ResourceService resourceService;
    @Inject
    Persona persona;

    @Override
    public boolean isAllowedTo(Operation operation, Resource resource, Persona persona) {
        if (null == resource) {
            throw new IllegalArgumentException("Resource to be checked is invalid (null).");
        }
        if (null == operation) {
            throw new IllegalArgumentException("Operation to be checked is invalid (null).");
        }
        if (null == persona) {
            throw new IllegalArgumentException("Persona that performs the operation is invalid (null).");
        }
        if (null == resource.getPersona()) {
            return this.isAllowedTo(operation, resource.getParent(), persona);
        }
        if (persona.equals(resource.getPersona())) {
            return true;
        }
        Set<Role> permittedRoles = this.permissionService.getPermittedRoles(operation);
        Set<Role> personaRoles = this.personaService.getEffectiveRolesForResource(persona, resource);
        return personaRoles.stream().anyMatch(permittedRoles::contains);
    }

    @Override
    public boolean isAllowedTo(Operation operation, String resourceId, Persona persona) {
        Resource resource = this.resourceService.get(resourceId);
        return this.isAllowedTo(operation, resource, persona);
    }

    @Override
    public boolean isAllowedTo(Operation operation, Resource resource) {
        return this.isAllowedTo(operation, resource, this.persona);
    }

    @Override
    public boolean isAllowedTo(Operation operation, String resourceId) {
        Resource resource = this.resourceService.get(resourceId);
        return this.isAllowedTo(operation, resource);
    }
}

