/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.Persona;

@Entity
public class Resource
extends BaseEntity {
    @ManyToOne
    private Persona persona;
    @ManyToOne
    private Resource parent = null;
    @OneToMany(mappedBy="parent")
    private List<Resource> children = new ArrayList<Resource>();

    protected Resource() {
    }

    public Resource(Persona persona) {
        this.setPersona(persona);
    }

    public Resource(Resource parent) {
        this.setParent(parent);
    }

    public Resource(Persona persona, Resource parent) {
        if (null == persona && null == parent) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        this.persona = persona;
        this.parent = parent;
    }

    public Resource(String id, Resource parent) {
        super(id);
        this.setParent(parent);
    }

    public Resource(String id, Persona persona) {
        super(id);
        this.setPersona(persona);
    }

    public Resource(String id, Persona persona, Resource parent) {
        super(id);
        if (null == persona && null == parent) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        this.persona = persona;
        this.parent = parent;
    }

    public Persona getPersona() {
        return this.persona;
    }

    public Resource getParent() {
        return this.parent;
    }

    public List<Resource> getSubResources() {
        return Collections.unmodifiableList(this.children);
    }

    public void setParent(Resource parent) {
        if (null == parent && null == this.persona) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        if (this.parent != null && this.parent.children.contains(this)) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            this.parent.children.add(this);
        }
    }

    public void setPersona(Persona persona) {
        if (null == persona && null == this.parent) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        this.persona = persona;
    }
}

