/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal;

import com.datastax.driver.core.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.common.internal.CassandraSessionCallable;

@Startup
@Singleton
@ApplicationScoped
@PermitAll
public class CassandraSessionInitializer {
    MsgLogger logger = MsgLogger.LOGGER;
    private Future<Session> sessionFuture;
    @Resource
    private ManagedExecutorService executor;
    @Inject
    CassandraSessionCallable cassandraSessionCallable;

    @PostConstruct
    public void init() {
        this.sessionFuture = this.executor.submit((Callable)this.cassandraSessionCallable);
    }

    @Produces
    @ApplicationScoped
    public Session getSession() {
        try {
            Session session = this.sessionFuture.get();
            InputStream input = this.getClass().getResourceAsStream("/hawkular_accounts.cql");
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                for (String cql : content.split("(?m)^-- #.*$")) {
                    if (cql.startsWith("--")) continue;
                    session.execute(cql);
                }
            }
            catch (Exception e) {
                this.logger.failedToInitializeSchema(e);
            }
            return session;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Could not get the initialized session.");
        }
    }
}

