/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hawkular.accounts.api.PersonaResourceRoleService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.PersonaResourceRole;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PersonaResourceRoleServiceImpl
extends BaseServiceImpl<PersonaResourceRole>
implements PersonaResourceRoleService {
    @Inject
    PersonaService personaService;
    @Inject
    ResourceService resourceService;
    @Inject
    RoleService roleService;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_GET_BY_ID)
    BoundStatement getById;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_GET_BY_PERSONA)
    BoundStatement getByPersona;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_GET_BY_RESOURCE)
    BoundStatement getByResource;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_CREATE)
    BoundStatement createStatement;
    @Inject
    @NamedStatement(value=BoundStatements.PRR_REMOVE)
    BoundStatement removeStatement;

    @Override
    PersonaResourceRole getFromRow(Row row) {
        Persona persona = this.personaService.getById(row.getUUID("persona"));
        Resource resource = this.resourceService.getById(row.getUUID("resource"));
        Role role = this.roleService.getById(row.getUUID("role"));
        PersonaResourceRole.Builder builder = new PersonaResourceRole.Builder();
        this.mapBaseFields(row, builder);
        return builder.persona(persona).resource(resource).role(role).build();
    }

    @Override
    public PersonaResourceRole getById(UUID id) {
        return (PersonaResourceRole)this.getById(id, this.getById);
    }

    @Override
    public PersonaResourceRole create(Persona persona, Resource resource, Role role) {
        PersonaResourceRole prr = new PersonaResourceRole(persona, role, resource);
        this.bindBasicParameters(prr, this.createStatement);
        this.createStatement.setUUID("persona", persona.getIdAsUUID());
        this.createStatement.setUUID("resource", resource.getIdAsUUID());
        this.createStatement.setUUID("role", role.getIdAsUUID());
        this.session.execute((Statement)this.createStatement);
        return prr;
    }

    @Override
    public void remove(UUID id) {
        this.session.execute((Statement)this.removeStatement.setUUID("id", id));
    }

    @Override
    public void remove(PersonaResourceRole personaResourceRole) {
        this.remove(personaResourceRole.getIdAsUUID());
    }

    @Override
    public List<PersonaResourceRole> getByPersona(Persona persona) {
        return this.getList(this.getByPersona.setUUID("persona", persona.getIdAsUUID()));
    }

    @Override
    public List<PersonaResourceRole> getByPersonaAndResource(Persona persona, Resource resource) {
        return this.getByPersona(persona).stream().filter(prr -> prr.getResource().equals(resource)).collect(Collectors.toList());
    }

    @Override
    public List<PersonaResourceRole> getByResource(Resource resource) {
        return this.getList(this.getByResource.setUUID("resource", resource.getIdAsUUID()));
    }
}

