/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.MsgLogger;

@ApplicationScoped
public class ApplicationResources {
    private Map<BoundStatements, PreparedStatement> statements = new HashMap<BoundStatements, PreparedStatement>(BoundStatements.values().length);
    private MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    Session session;

    @PostConstruct
    public void buildStatements() {
        for (BoundStatements statement : BoundStatements.values()) {
            if (statement.equals((Object)BoundStatements.DEFAULT)) continue;
            try {
                this.statements.put(statement, this.session.prepare(statement.getValue()));
            }
            catch (InvalidQueryException e) {
                this.logger.couldNotPrepareQuery(statement.getValue(), e);
            }
        }
    }

    @Produces
    @NamedStatement
    public BoundStatement produceStatementByName(InjectionPoint injectionPoint) {
        NamedStatement annotation = (NamedStatement)injectionPoint.getAnnotated().getAnnotation(NamedStatement.class);
        BoundStatements stmtName = annotation.value();
        return this.getBoundStatement(stmtName);
    }

    public BoundStatement getBoundStatement(BoundStatements statement) {
        if (this.statements.size() == 0) {
            this.buildStatements();
        }
        return new BoundStatement(this.statements.get((Object)statement));
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

