/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OrganizationMembershipServiceImpl
extends BaseServiceImpl<OrganizationMembership>
implements OrganizationMembershipService {
    @Inject
    ResourceService resourceService;
    @Inject
    PersonaService personaService;
    @Inject
    OrganizationService organizationService;
    @Inject
    RoleService roleService;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_GET_BY_ID)
    BoundStatement getById;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_GET_BY_ORGANIZATION)
    BoundStatement getByOrganization;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_GET_BY_PERSONA)
    BoundStatement getByPersona;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_REMOVE)
    BoundStatement removeStatement;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_CREATE)
    BoundStatement createStatement;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_CHANGE_ROLE)
    BoundStatement changeRoleStatement;

    @Override
    public OrganizationMembership create(Organization organization, Persona persona, Role role) {
        OrganizationMembership membership = new OrganizationMembership(organization, persona, role);
        this.bindBasicParameters(membership, this.createStatement);
        this.createStatement.setUUID("member", membership.getMember().getIdAsUUID());
        this.createStatement.setUUID("organization", membership.getOrganization().getIdAsUUID());
        this.createStatement.setUUID("role", membership.getRole().getIdAsUUID());
        this.session.execute((Statement)this.createStatement);
        Resource resource = this.resourceService.getById(organization.getIdAsUUID());
        this.resourceService.addRoleToPersona(resource, persona, role);
        return membership;
    }

    @Override
    public List<OrganizationMembership> getMembershipsForPersona(Persona persona) {
        return this.getList(this.getByPersona.setUUID("member", persona.getIdAsUUID()));
    }

    @Override
    public List<OrganizationMembership> getMembershipsForOrganization(Organization organization) {
        return this.getList(this.getByOrganization.setUUID("organization", organization.getIdAsUUID()));
    }

    @Override
    public List<OrganizationMembership> getPersonaMembershipsForOrganization(Persona persona, Organization organization) {
        return this.getMembershipsForPersona(persona).stream().filter(m -> m.getOrganization().equals(organization)).collect(Collectors.toList());
    }

    @Override
    public OrganizationMembership getMembershipById(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public OrganizationMembership getById(UUID id) {
        if (null == id) {
            throw new IllegalArgumentException("The given membership ID is invalid (null).");
        }
        return (OrganizationMembership)this.getById(id, this.getById);
    }

    @Override
    public OrganizationMembership changeRole(OrganizationMembership membership, Role role) {
        membership.setRole(role);
        this.changeRoleStatement.setUUID("role", membership.getRole().getIdAsUUID());
        this.update(membership, this.changeRoleStatement);
        Persona persona = this.personaService.getById(membership.getMember().getIdAsUUID());
        Resource resource = this.resourceService.getById(membership.getOrganization().getIdAsUUID());
        this.resourceService.revokeAllForPersona(resource, persona);
        this.resourceService.addRoleToPersona(resource, persona, role);
        return membership;
    }

    @Override
    public void remove(OrganizationMembership organizationMembership) {
        this.remove(organizationMembership.getIdAsUUID());
    }

    @Override
    public void remove(UUID id) {
        this.session.execute((Statement)this.removeStatement.setUUID("id", id));
    }

    @Override
    OrganizationMembership getFromRow(Row row) {
        Organization organization = this.organizationService.getById(row.getUUID("organization"));
        Persona member = this.personaService.getById(row.getUUID("member"));
        Role role = this.roleService.getById(row.getUUID("role"));
        OrganizationMembership.Builder builder = new OrganizationMembership.Builder();
        this.mapBaseFields(row, builder);
        return builder.organization(organization).member(member).role(role).build();
    }
}

