/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.PersonaResourceRoleService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.PersonaResourceRole;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class ResourceServiceImpl
extends BaseServiceImpl<Resource>
implements ResourceService {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}");
    @Inject
    Persona persona;
    @Inject
    @NamedRole(value="SuperUser")
    Role superUser;
    @Inject
    PersonaResourceRoleService personaResourceRoleService;
    @Inject
    PersonaService personaService;
    @Inject
    @NamedStatement(value=BoundStatements.RESOURCE_GET_BY_ID)
    BoundStatement getById;
    @Inject
    @NamedStatement(value=BoundStatements.RESOURCE_GET_BY_PERSONA)
    BoundStatement getByPersona;
    @Inject
    @NamedStatement(value=BoundStatements.RESOURCE_CREATE)
    BoundStatement createStatement;
    @Inject
    @NamedStatement(value=BoundStatements.RESOURCE_TRANSFER)
    BoundStatement transferStatement;

    @Override
    public Resource getById(UUID id) {
        return (Resource)this.getById(id, this.getById);
    }

    @Override
    public Resource get(String id) {
        UUID uuid = !UUID_PATTERN.matcher(id).matches() ? UUID.nameUUIDFromBytes(id.getBytes()) : UUID.fromString(id);
        return this.getById(uuid);
    }

    @Override
    public Resource create(String id, Persona persona) {
        if (null == persona) {
            throw new IllegalArgumentException("The specified persona is invalid (null).");
        }
        return this.create(id, null, persona);
    }

    @Override
    public Resource create(String id, Resource parent) {
        if (null == parent) {
            throw new IllegalArgumentException("The given parent resource is invalid (null).");
        }
        return this.create(id, parent, null);
    }

    @Override
    public Resource create(String id, Resource parent, Persona persona) {
        if (null == parent && null == persona) {
            throw new IllegalArgumentException("Either parent or persona should be provided when creating a resource");
        }
        Resource resource = new Resource(id, persona, parent);
        this.bindBasicParameters(resource, this.createStatement);
        if (null != persona) {
            this.createStatement.setUUID("persona", resource.getPersona().getIdAsUUID());
        } else {
            this.createStatement.setToNull("persona");
        }
        if (null != parent) {
            this.createStatement.setUUID("parent", resource.getParent().getIdAsUUID());
        } else {
            this.createStatement.setToNull("parent");
        }
        this.session.execute((Statement)this.createStatement);
        if (persona != null) {
            this.personaResourceRoleService.create(persona, resource, this.superUser);
        }
        return resource;
    }

    @Override
    public void delete(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The given resource ID is invalid (null).");
        }
        Resource resource = this.get(id);
        if (resource != null) {
            this.personaResourceRoleService.getByResource(resource).stream().forEach(this.personaResourceRoleService::remove);
        }
    }

    @Override
    public List<Resource> getByPersona(Persona persona) {
        if (null == persona) {
            throw new IllegalArgumentException("The given persona is invalid (null).");
        }
        return this.getList(this.getByPersona.setUUID("persona", persona.getIdAsUUID()));
    }

    @Override
    public void transfer(Resource resource, Persona persona) {
        resource.setPersona(persona);
        this.update(resource, this.transferStatement.setUUID("persona", persona.getIdAsUUID()));
        this.revokeAllForPersona(resource, persona);
        this.addRoleToPersona(resource, persona, this.superUser);
    }

    @Override
    public void revokeAllForPersona(Resource resource, Persona persona) {
        this.personaResourceRoleService.getByPersonaAndResource(persona, resource).stream().forEach(this.personaResourceRoleService::remove);
    }

    @Override
    public PersonaResourceRole addRoleToPersona(Resource resource, Persona persona, Role role) {
        List existingList = this.personaResourceRoleService.getByPersonaAndResource(persona, resource).stream().filter(prr -> prr.getRole().equals(role)).collect(Collectors.toList());
        if (existingList.size() > 0) {
            return (PersonaResourceRole)existingList.get(0);
        }
        return this.personaResourceRoleService.create(persona, resource, role);
    }

    @Override
    public List<PersonaResourceRole> getRolesForPersona(Resource resource, Persona persona) {
        return this.personaResourceRoleService.getByPersonaAndResource(persona, resource);
    }

    @Override
    Resource getFromRow(Row row) {
        Resource parent = null;
        Persona persona = null;
        if (!row.isNull("parent")) {
            parent = this.getById(row.getUUID("parent"));
        }
        if (!row.isNull("persona")) {
            persona = this.personaService.getById(row.getUUID("persona"));
        }
        Resource.Builder builder = new Resource.Builder().parent(parent).persona(persona);
        this.mapBaseFields(row, builder);
        return builder.build();
    }
}

