/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.security.InvalidParameterException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class RoleServiceImpl
extends BaseServiceImpl<Role>
implements RoleService {
    @Inject
    @NamedStatement(value=BoundStatements.ROLES_GET_BY_ID)
    BoundStatement getByIdStatement;
    @Inject
    @NamedStatement(value=BoundStatements.ROLES_CREATE)
    BoundStatement createStatement;
    @Inject
    @NamedStatement(value=BoundStatements.ROLES_GET_BY_NAME)
    BoundStatement getByNameStatement;

    @Override
    public Role getById(UUID id) {
        return (Role)this.getById(id, this.getByIdStatement);
    }

    @Override
    public Role create(String name, String description) {
        if (null != this.getByName(name)) {
            throw new InvalidParameterException("There's already a role with the given name.");
        }
        Role role = new Role(name, description);
        this.bindBasicParameters(role, this.createStatement);
        this.createStatement.setString("name", name);
        this.createStatement.setString("description", description);
        this.session.execute((Statement)this.createStatement);
        return role;
    }

    @Override
    public Role getByName(String name) {
        this.getByNameStatement.setString("name", name);
        return (Role)this.getSingleRecord(this.getByNameStatement);
    }

    @Override
    public Set<Role> getImplicitUserRoles(String name) {
        HashSet<Role> implicitRoles = new HashSet<Role>(7);
        switch (name) {
            case "SuperUser": {
                implicitRoles.add(this.getByName("Auditor"));
                implicitRoles.add(this.getByName("Administrator"));
                implicitRoles.add(this.getByName("Deployer"));
            }
            case "Deployer": 
            case "Administrator": {
                implicitRoles.add(this.getByName("Maintainer"));
            }
            case "Maintainer": {
                implicitRoles.add(this.getByName("Operator"));
            }
            case "Auditor": 
            case "Operator": {
                implicitRoles.add(this.getByName("Monitor"));
            }
            case "Monitor": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized role: '" + name + "'");
            }
        }
        return implicitRoles;
    }

    @Override
    public Set<Role> getImplicitPermittedRoles(String name) {
        HashSet<Role> implicitRoles = new HashSet<Role>(7);
        switch (name) {
            case "Monitor": {
                implicitRoles.add(this.getByName("Operator"));
                implicitRoles.add(this.getByName("Auditor"));
            }
            case "Operator": {
                implicitRoles.add(this.getByName("Maintainer"));
            }
            case "Maintainer": {
                implicitRoles.add(this.getByName("Administrator"));
                implicitRoles.add(this.getByName("Deployer"));
            }
            case "Deployer": 
            case "Administrator": 
            case "Auditor": {
                implicitRoles.add(this.getByName("SuperUser"));
            }
            case "SuperUser": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized role: '" + name + "'");
            }
        }
        return implicitRoles;
    }

    @Override
    public Set<Role> getImplicitUserRoles(Role role) {
        return this.getImplicitUserRoles(role.getName());
    }

    @Override
    public Set<Role> getImplicitPermittedRoles(Role role) {
        return this.getImplicitPermittedRoles(role.getName());
    }

    @Override
    @Produces
    @NamedRole
    public Role produceRoleByName(InjectionPoint injectionPoint) {
        NamedRole namedRole = (NamedRole)injectionPoint.getAnnotated().getAnnotation(NamedRole.class);
        String roleName = namedRole.value();
        return this.getByName(roleName);
    }

    @Override
    public Role getOrCreateByName(String name, String description) {
        Role role = this.getByName(name);
        if (null == role) {
            role = this.create(name, description);
        }
        return role;
    }

    @Override
    Role getFromRow(Row row) {
        String name = row.getString("name");
        String description = row.getString("description");
        Role.Builder builder = new Role.Builder();
        super.mapBaseFields(row, builder);
        return builder.description(description).name(name).build();
    }
}

