/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.HawkularUser;
import org.keycloak.KeycloakPrincipal;

@Stateless
@PermitAll
public class UserServiceImpl
extends BaseServiceImpl<HawkularUser>
implements UserService {
    @Resource
    SessionContext sessionContext;
    @Inject
    @NamedStatement(value=BoundStatements.USER_GET_BY_ID)
    BoundStatement getByIdStatement;
    @Inject
    @NamedStatement(value=BoundStatements.USER_CREATE)
    BoundStatement createStatement;
    @Inject
    @NamedStatement(value=BoundStatements.USER_UPDATE)
    BoundStatement updateStatement;
    @Inject
    @NamedStatement(value=BoundStatements.USER_ALL)
    BoundStatement allUsersStatement;

    @Override
    @Produces
    @CurrentUser
    public HawkularUser getCurrent() {
        HawkularUser user;
        KeycloakPrincipal principal = (KeycloakPrincipal)this.sessionContext.getCallerPrincipal();
        String id = principal.getName();
        String name = principal.getKeycloakSecurityContext().getToken().getName();
        if (!name.equals((user = this.getOrCreateByIdAndName(id, name)).getName())) {
            user.setName(name);
            return this.update(user);
        }
        return user;
    }

    @Override
    public HawkularUser getById(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public HawkularUser getById(UUID id) {
        return (HawkularUser)this.getById(id, this.getByIdStatement);
    }

    @Override
    public HawkularUser getOrCreateById(String id) {
        HawkularUser user = this.getById(id);
        if (null == user) {
            user = this.create(id, null);
        }
        return user;
    }

    @Override
    public HawkularUser getOrCreateByIdAndName(String id, String name) {
        HawkularUser user = this.getById(id);
        if (null == user) {
            user = this.create(id, name);
        }
        return user;
    }

    private HawkularUser create(UUID id, String name) {
        HawkularUser user = new HawkularUser(id, name);
        this.bindBasicParameters(user, this.createStatement);
        this.createStatement.setString("name", user.getName());
        this.session.execute((Statement)this.createStatement);
        return user;
    }

    private HawkularUser update(HawkularUser user) {
        this.updateStatement.setString("name", user.getName());
        return this.update(user, this.updateStatement);
    }

    private HawkularUser create(String id, String name) {
        return this.create(UUID.fromString(id), name);
    }

    List<HawkularUser> getAll() {
        return this.getList(this.allUsersStatement);
    }

    @Override
    HawkularUser getFromRow(Row row) {
        HawkularUser.Builder builder = new HawkularUser.Builder();
        this.mapBaseFields(row, builder);
        return builder.name(row.getString("name")).build();
    }
}

