/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Invitation;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OrganizationServiceImpl
extends BaseServiceImpl<Organization>
implements OrganizationService {
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    ResourceService resourceService;
    @Inject
    InvitationService invitationService;
    @Inject
    PersonaService personaService;
    @Inject
    @NamedRole(value="SuperUser")
    Role superUser;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_GET_BY_ID)
    BoundStatement getById;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_GET_BY_OWNER)
    BoundStatement getByOwner;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_CREATE)
    BoundStatement createStatement;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_REMOVE)
    BoundStatement removeStatement;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_TRANSFER)
    BoundStatement transferStatement;

    @Override
    public Organization getById(UUID id) {
        if (null == id) {
            throw new IllegalArgumentException("The given organization ID is invalid (null).");
        }
        return (Organization)this.getById(id, this.getById);
    }

    @Override
    public Organization get(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public List<Organization> getOrganizationsForPersona(Persona persona) {
        return this.getOrganizationsFromMemberships(this.membershipService.getMembershipsForPersona(persona));
    }

    @Override
    public List<Organization> getOrganizationsFromMemberships(List<OrganizationMembership> memberships) {
        return memberships.stream().map(OrganizationMembership::getOrganization).distinct().collect(Collectors.toList());
    }

    @Override
    public Organization createOrganization(String name, String description, Persona owner) {
        Organization organization = new Organization(owner);
        organization.setName(name);
        organization.setDescription(description);
        Resource resource = this.resourceService.create(organization.getId(), owner);
        this.resourceService.addRoleToPersona(resource, owner, this.superUser);
        this.bindBasicParameters(organization, this.createStatement);
        this.createStatement.setString("name", organization.getName());
        this.createStatement.setString("description", organization.getDescription());
        this.createStatement.setUUID("owner", organization.getOwner().getIdAsUUID());
        this.session.execute((Statement)this.createStatement);
        this.membershipService.create(organization, owner, this.superUser);
        return organization;
    }

    @Override
    public void deleteOrganization(Organization organization) {
        Resource resource = this.resourceService.get(organization.getId());
        this.invitationService.getInvitationsForOrganization(organization).stream().forEach(invitation -> {
            if (null != invitation.getAcceptedBy()) {
                this.resourceService.revokeAllForPersona(resource, invitation.getAcceptedBy());
            }
            this.invitationService.remove((Invitation)invitation);
        });
        this.membershipService.getMembershipsForOrganization(organization).stream().forEach(this.membershipService::remove);
        this.resourceService.revokeAllForPersona(resource, organization.getOwner());
        this.resourceService.delete(organization.getId());
        this.session.execute((Statement)this.removeStatement.setUUID("id", organization.getIdAsUUID()));
    }

    @Override
    public void transfer(Organization organization, Persona newOwner) {
        this.membershipService.getPersonaMembershipsForOrganization(newOwner, organization).stream().forEach(this.membershipService::remove);
        this.membershipService.create(organization, newOwner, this.superUser);
        Resource resource = this.resourceService.getById(organization.getIdAsUUID());
        this.resourceService.transfer(resource, newOwner);
        organization.setOwner(newOwner);
        this.transferStatement.setUUID("owner", organization.getOwner().getIdAsUUID());
        this.session.execute((Statement)this.transferStatement);
    }

    @Override
    public List<Organization> getSubOrganizations(Organization organization) {
        return this.getList(this.getByOwner.setUUID("owner", organization.getIdAsUUID()));
    }

    @Override
    Organization getFromRow(Row row) {
        Persona owner = this.personaService.getById(row.getUUID("owner"));
        String name = row.getString("name");
        String description = row.getString("description");
        Organization.Builder builder = new Organization.Builder();
        this.mapBaseFields(row, builder);
        return builder.owner(owner).name(name).description(description).build();
    }
}

