/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.common.ZonedDateTimeAdapter;

public abstract class BaseServiceImpl<T extends BaseEntity> {
    @Inject
    ZonedDateTimeAdapter zonedDateTimeAdapter;
    @Inject
    Session session;

    public T getById(UUID uuid, BoundStatement statement) {
        if (null == uuid) {
            throw new IllegalArgumentException("The given ID is invalid (null).");
        }
        return this.getSingleRecord(statement.setUUID("id", uuid));
    }

    T getSingleRecord(BoundStatement statement) {
        Row row = this.session.execute((Statement)statement).one();
        if (null == row) {
            return null;
        }
        return this.getFromRow(row);
    }

    List<T> getList(BoundStatement statement) {
        return this.getFromRows(this.session.execute((Statement)statement).all());
    }

    List<T> getFromRows(List<Row> rows) {
        return rows.stream().map(this::getFromRow).collect(Collectors.toList());
    }

    T update(T record, BoundStatement statement) {
        ((BaseEntity)record).setUpdatedAt();
        statement.setTimestamp("updatedAt", (Date)this.zonedDateTimeAdapter.convertToDatabaseColumn(((BaseEntity)record).getUpdatedAt()));
        statement.setUUID("id", ((BaseEntity)record).getIdAsUUID());
        this.session.execute((Statement)statement);
        return record;
    }

    void mapBaseFields(Row row, BaseEntity.Builder builder) {
        UUID id = row.getUUID("id");
        ZonedDateTime createdAt = this.zonedDateTimeAdapter.convertToEntityAttribute(row.getTimestamp("createdAt"));
        ZonedDateTime updatedAt = this.zonedDateTimeAdapter.convertToEntityAttribute(row.getTimestamp("updatedAt"));
        builder.createdAt(createdAt).updatedAt(updatedAt).id(id);
    }

    void bindBasicParameters(T t, BoundStatement statement) {
        statement.setUUID("id", ((BaseEntity)t).getIdAsUUID());
        statement.setTimestamp("createdAt", (Date)this.zonedDateTimeAdapter.convertToDatabaseColumn(((BaseEntity)t).getCreatedAt()));
        statement.setTimestamp("updatedAt", (Date)this.zonedDateTimeAdapter.convertToDatabaseColumn(((BaseEntity)t).getUpdatedAt()));
    }

    abstract T getFromRow(Row var1);
}

