/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Invitation;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class InvitationServiceImpl
extends BaseServiceImpl<Invitation>
implements InvitationService {
    @Inject
    RoleService roleService;
    @Inject
    OrganizationService organizationService;
    @Inject
    UserService userService;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    @NamedStatement(value=BoundStatements.INVITATION_GET_BY_TOKEN)
    Instance<BoundStatement> stmtGetByTokenInstance;
    @Inject
    @NamedStatement(value=BoundStatements.INVITATIONS_GET_BY_ORGANIZATION)
    Instance<BoundStatement> stmtGetByOrganizationInstance;
    @Inject
    @NamedStatement(value=BoundStatements.INVITATIONS_CREATE)
    Instance<BoundStatement> stmtCreateInstance;
    @Inject
    @NamedStatement(value=BoundStatements.INVITATIONS_ACCEPT)
    Instance<BoundStatement> stmtAcceptInstance;
    @Inject
    @NamedStatement(value=BoundStatements.INVITATIONS_DISPATCH)
    Instance<BoundStatement> stmtDispatchedInstance;
    @Inject
    @NamedStatement(value=BoundStatements.INVITATIONS_DELETE)
    Instance<BoundStatement> stmtDeleteInstance;

    @Override
    public Invitation getById(UUID token) {
        return (Invitation)this.getById(token, (BoundStatement)this.stmtGetByTokenInstance.get());
    }

    @Override
    public Invitation get(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public Invitation getByToken(String token) {
        return this.get(token);
    }

    @Override
    public List<Invitation> getPendingInvitationsForOrganization(Organization organization) {
        return this.getInvitationsForOrganization(organization).stream().filter(i -> i.getAcceptedAt() == null).collect(Collectors.toList());
    }

    @Override
    public List<Invitation> getInvitationsForOrganization(Organization organization) {
        if (null == organization) {
            throw new IllegalArgumentException("The given Organization is invalid (null).");
        }
        return this.getList(((BoundStatement)this.stmtGetByOrganizationInstance.get()).setUUID("organization", organization.getIdAsUUID()));
    }

    @Override
    public Invitation create(String email, HawkularUser invitedBy, Organization organization, Role role) {
        BoundStatement stmtCreateStatement = (BoundStatement)this.stmtCreateInstance.get();
        Invitation invitation = new Invitation(email, invitedBy, organization, role);
        this.bindBasicParameters(invitation, stmtCreateStatement);
        stmtCreateStatement.setString("email", invitation.getEmail());
        stmtCreateStatement.setUUID("invitedBy", invitation.getInvitedBy().getIdAsUUID());
        stmtCreateStatement.setUUID("organization", invitation.getOrganization().getIdAsUUID());
        stmtCreateStatement.setUUID("role", invitation.getRole().getIdAsUUID());
        this.session.execute((Statement)stmtCreateStatement);
        return invitation;
    }

    @Override
    public Invitation accept(Invitation invitation, HawkularUser user) {
        BoundStatement stmtAccept = (BoundStatement)this.stmtAcceptInstance.get();
        this.membershipService.create(invitation.getOrganization(), user, invitation.getRole());
        invitation.setAccepted();
        invitation.setAcceptedBy(user);
        stmtAccept.setTimestamp("acceptedAt", (Date)this.zonedDateTimeAdapter.convertToDatabaseColumn(invitation.getAcceptedAt()));
        this.update(invitation, stmtAccept);
        return invitation;
    }

    @Override
    public void remove(Invitation invitation) {
        BoundStatement stmtDelete = (BoundStatement)this.stmtDeleteInstance.get();
        if (null != invitation) {
            stmtDelete.setUUID("id", invitation.getIdAsUUID());
            this.session.execute((Statement)stmtDelete);
        }
    }

    @Override
    public void markAsDispatched(Invitation invitation) {
        BoundStatement stmtDispatched = (BoundStatement)this.stmtDispatchedInstance.get();
        invitation.setDispatched();
        stmtDispatched.setUUID("id", invitation.getIdAsUUID());
        stmtDispatched.setTimestamp("dispatchedAt", (Date)this.zonedDateTimeAdapter.convertToDatabaseColumn(invitation.getDispatchedAt()));
        this.update(invitation, stmtDispatched);
    }

    @Override
    Invitation getFromRow(Row row) {
        Role role = this.roleService.getById(row.getUUID("role"));
        Organization organization = this.organizationService.getById(row.getUUID("organization"));
        HawkularUser invitedBy = this.userService.getById(row.getUUID("invitedBy"));
        String email = row.getString("email");
        HawkularUser acceptedBy = null;
        if (!row.isNull("acceptedBy")) {
            acceptedBy = this.userService.getById(row.getUUID("acceptedBy"));
        }
        ZonedDateTime acceptedAt = null;
        if (!row.isNull("acceptedAt")) {
            acceptedAt = this.zonedDateTimeAdapter.convertToEntityAttribute(row.getTimestamp("acceptedAt"));
        }
        ZonedDateTime dispatchedAt = null;
        if (!row.isNull("dispatchedAt")) {
            dispatchedAt = this.zonedDateTimeAdapter.convertToEntityAttribute(row.getTimestamp("dispatchedAt"));
        }
        Invitation.Builder builder = new Invitation.Builder();
        this.mapBaseFields(row, builder);
        return builder.role(role).acceptedAt(acceptedAt).dispatchedAt(dispatchedAt).organization(organization).acceptedBy(acceptedBy).invitedBy(invitedBy).email(email).build();
    }
}

