/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.OrganizationJoinRequestService;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.api.model.JoinRequestStatus;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationJoinRequest;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;
import org.hawkular.accounts.api.model.Visibility;

@Stateless
@PermitAll
public class OrganizationJoinRequestServiceImpl
extends BaseServiceImpl<OrganizationJoinRequest>
implements OrganizationJoinRequestService {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    ResourceService resourceService;
    @Inject
    OrganizationService organizationService;
    @Inject
    PersonaService personaService;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    @NamedStatement(value=BoundStatements.JOIN_REQUEST_GET_BY_ID)
    Instance<BoundStatement> stmtGetById;
    @Inject
    @NamedStatement(value=BoundStatements.JOIN_REQUEST_CREATE)
    Instance<BoundStatement> stmtCreate;
    @Inject
    @NamedStatement(value=BoundStatements.JOIN_REQUEST_REMOVE)
    Instance<BoundStatement> stmtRemove;
    @Inject
    @NamedStatement(value=BoundStatements.JOIN_REQUEST_UPDATE_STATUS)
    Instance<BoundStatement> stmtUpdateStatus;
    @Inject
    @NamedStatement(value=BoundStatements.JOIN_REQUEST_LIST_BY_ORGANIZATION)
    Instance<BoundStatement> stmtListByOrganization;
    @Inject
    @NamedStatement(value=BoundStatements.JOIN_REQUEST_LIST_BY_PERSONA)
    Instance<BoundStatement> stmtListByPersona;
    @Inject
    @NamedRole(value="SuperUser")
    Role superUser;

    @Override
    public OrganizationJoinRequest getById(UUID uuid) {
        return (OrganizationJoinRequest)this.getById(uuid, (BoundStatement)this.stmtGetById.get());
    }

    @Override
    public OrganizationJoinRequest create(Organization organization, Persona persona) {
        if (null == organization) {
            throw new IllegalArgumentException("Invalid organization (null)");
        }
        if (null == persona) {
            throw new IllegalArgumentException("Invalid persona (null)");
        }
        if (organization.getVisibility().equals((Object)Visibility.PRIVATE)) {
            throw new IllegalArgumentException("This organization is private, users cannot apply to join.");
        }
        BoundStatement createStatement = (BoundStatement)this.stmtCreate.get();
        OrganizationJoinRequest joinRequest = new OrganizationJoinRequest(organization, persona, JoinRequestStatus.PENDING);
        Resource resource = this.resourceService.create(joinRequest.getId(), organization);
        this.resourceService.addRoleToPersona(resource, organization, this.superUser);
        this.bindBasicParameters(joinRequest, createStatement);
        createStatement.setUUID("organization", joinRequest.getOrganization().getIdAsUUID());
        createStatement.setUUID("persona", joinRequest.getPersona().getIdAsUUID());
        createStatement.setString("status", joinRequest.getStatus().name());
        this.session.execute((Statement)createStatement);
        this.logger.joinRequestCreated(joinRequest.getPersona().getId(), joinRequest.getOrganization().getId(), joinRequest.getId());
        return joinRequest;
    }

    @Override
    public OrganizationJoinRequest accept(OrganizationJoinRequest request, Role role) {
        if (null == request) {
            throw new IllegalArgumentException("Invalid join request (null)");
        }
        if (null == role) {
            throw new IllegalArgumentException("Invalid role (null)");
        }
        if (!JoinRequestStatus.PENDING.equals((Object)request.getStatus())) {
            throw new IllegalStateException("Only join requests in PENDING state can be accepted.");
        }
        request.setStatus(JoinRequestStatus.ACCEPTED);
        this.membershipService.create(request.getOrganization(), request.getPersona(), role);
        return this.update(request, ((BoundStatement)this.stmtUpdateStatus.get()).setString("status", request.getStatus().name()));
    }

    @Override
    public OrganizationJoinRequest reject(OrganizationJoinRequest request) {
        if (!JoinRequestStatus.PENDING.equals((Object)request.getStatus())) {
            throw new IllegalStateException("Only join requests in PENDING state can be accepted.");
        }
        request.setStatus(JoinRequestStatus.REJECTED);
        return this.update(request, ((BoundStatement)this.stmtUpdateStatus.get()).setString("status", request.getStatus().name()));
    }

    @Override
    public void remove(OrganizationJoinRequest request) {
        this.session.execute((Statement)((BoundStatement)this.stmtRemove.get()).setUUID("id", request.getIdAsUUID()));
    }

    @Override
    public List<OrganizationJoinRequest> getPendingRequestsForOrganization(Organization organization) {
        return this.getAllRequestsForOrganization(organization).stream().filter(r -> r.getStatus().equals((Object)JoinRequestStatus.PENDING)).collect(Collectors.toList());
    }

    @Override
    public List<OrganizationJoinRequest> getAllRequestsForOrganization(Organization organization) {
        return this.getList(((BoundStatement)this.stmtListByOrganization.get()).setUUID("organization", organization.getIdAsUUID()));
    }

    @Override
    public List<OrganizationJoinRequest> getAllRequestsForPersona(Persona persona) {
        return this.getList(((BoundStatement)this.stmtListByPersona.get()).setUUID("persona", persona.getIdAsUUID()));
    }

    @Override
    OrganizationJoinRequest getFromRow(Row row) {
        OrganizationJoinRequest.Builder builder = new OrganizationJoinRequest.Builder();
        this.mapBaseFields(row, builder);
        return builder.organization(this.organizationService.getById(row.getUUID("organization"))).persona(this.personaService.getById(row.getUUID("persona"))).status(JoinRequestStatus.valueOf(row.getString("status"))).build();
    }
}

