/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Permission;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PermissionServiceImpl
extends BaseServiceImpl<Permission>
implements PermissionService {
    @Inject
    OperationService operationService;
    @Inject
    RoleService roleService;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSION_GET_BY_ID)
    Instance<BoundStatement> stmtGetByIdInstance;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSION_DELETE)
    Instance<BoundStatement> stmtDeleteInstance;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSIONS_GET_BY_OPERATION)
    Instance<BoundStatement> stmtGetByOperationInstance;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSION_CREATE)
    Instance<BoundStatement> stmtCreateInstance;

    @Override
    public Set<Role> getPermittedRoles(Operation operation) {
        return this.getPermissionsForOperation(operation).stream().map(Permission::getRole).collect(Collectors.toSet());
    }

    @Override
    public Set<Permission> getPermissionsForOperation(Operation operation) {
        return this.getList(((BoundStatement)this.stmtGetByOperationInstance.get()).setUUID("operation", operation.getIdAsUUID())).stream().collect(Collectors.toSet());
    }

    @Override
    public Permission getById(UUID id) {
        return (Permission)this.getById(id, (BoundStatement)this.stmtGetByIdInstance.get());
    }

    @Override
    public Permission create(Operation operation, Role role) {
        BoundStatement stmtCreate = (BoundStatement)this.stmtCreateInstance.get();
        Permission permission = new Permission(operation, role);
        this.bindBasicParameters(permission, stmtCreate);
        stmtCreate.setUUID("operation", permission.getOperation().getIdAsUUID());
        stmtCreate.setUUID("role", permission.getRole().getIdAsUUID());
        this.session.execute((Statement)stmtCreate);
        return permission;
    }

    @Override
    public void remove(Permission permission) {
        this.session.execute((Statement)((BoundStatement)this.stmtDeleteInstance.get()).setUUID("id", permission.getIdAsUUID()));
    }

    @Override
    Permission getFromRow(Row row) {
        Operation operation = this.operationService.getById(row.getUUID("operation"));
        Role role = this.roleService.getById(row.getUUID("role"));
        Permission.Builder builder = new Permission.Builder();
        super.mapBaseFields(row, builder);
        return builder.operation(operation).role(role).build();
    }
}

