/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;

public class Role
extends BaseEntity {
    private String name;
    private String description;

    protected Role() {
    }

    public Role(String name, String description) {
        this(UUID.randomUUID(), name, description);
    }

    public Role(String id, String name, String description) {
        this(UUID.fromString(id), name, description);
    }

    public Role(UUID id, String name, String description) {
        super(id);
        if (null == name) {
            throw new IllegalStateException("A role name is required to build a role.");
        }
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return "Role{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", base='" + super.toString() + '\'' + '}';
    }

    public static class Builder
    extends BaseEntity.Builder {
        private String name;
        private String description;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Role build() {
            return new Role(this.id, this.name, this.description);
        }
    }
}

