/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OrganizationMembershipServiceImpl
extends BaseServiceImpl<OrganizationMembership>
implements OrganizationMembershipService {
    @Inject
    ResourceService resourceService;
    @Inject
    PersonaService personaService;
    @Inject
    OrganizationService organizationService;
    @Inject
    RoleService roleService;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_GET_BY_ID)
    Instance<BoundStatement> stmtGetByIdInstance;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_GET_BY_ORGANIZATION)
    Instance<BoundStatement> stmtGetByOrganizationInstance;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_GET_BY_PERSONA)
    Instance<BoundStatement> stmtGetByPersonaInstance;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_REMOVE)
    Instance<BoundStatement> stmtRemoveInstance;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_CREATE)
    Instance<BoundStatement> stmtCreateInstance;
    @Inject
    @NamedStatement(value=BoundStatements.MEMBERSHIP_CHANGE_ROLE)
    Instance<BoundStatement> stmtChangeRoleInstance;

    @Override
    public OrganizationMembership create(Organization organization, Persona persona, Role role) {
        BoundStatement stmtCreate = (BoundStatement)this.stmtCreateInstance.get();
        OrganizationMembership membership = new OrganizationMembership(organization, persona, role);
        this.bindBasicParameters(membership, stmtCreate);
        stmtCreate.setUUID("member", membership.getMember().getIdAsUUID());
        stmtCreate.setUUID("organization", membership.getOrganization().getIdAsUUID());
        stmtCreate.setUUID("role", membership.getRole().getIdAsUUID());
        this.session.execute((Statement)stmtCreate);
        Resource resource = this.resourceService.getById(organization.getIdAsUUID());
        this.resourceService.addRoleToPersona(resource, persona, role);
        return membership;
    }

    @Override
    public List<OrganizationMembership> getMembershipsForPersona(Persona persona) {
        return this.getList(((BoundStatement)this.stmtGetByPersonaInstance.get()).setUUID("member", persona.getIdAsUUID()));
    }

    @Override
    public List<OrganizationMembership> getMembershipsForOrganization(Organization organization) {
        return this.getList(((BoundStatement)this.stmtGetByOrganizationInstance.get()).setUUID("organization", organization.getIdAsUUID()));
    }

    @Override
    public List<OrganizationMembership> getPersonaMembershipsForOrganization(Persona persona, Organization organization) {
        return this.getMembershipsForPersona(persona).stream().filter(m -> m.getOrganization().equals(organization)).collect(Collectors.toList());
    }

    @Override
    public OrganizationMembership getMembershipById(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public OrganizationMembership getById(UUID id) {
        if (null == id) {
            throw new IllegalArgumentException("The given membership ID is invalid (null).");
        }
        return (OrganizationMembership)this.getById(id, (BoundStatement)this.stmtGetByIdInstance.get());
    }

    @Override
    public OrganizationMembership changeRole(OrganizationMembership membership, Role role) {
        BoundStatement stmtChangeRole = (BoundStatement)this.stmtChangeRoleInstance.get();
        membership.setRole(role);
        stmtChangeRole.setUUID("role", membership.getRole().getIdAsUUID());
        this.update(membership, stmtChangeRole);
        Persona persona = this.personaService.getById(membership.getMember().getIdAsUUID());
        Resource resource = this.resourceService.getById(membership.getOrganization().getIdAsUUID());
        this.resourceService.revokeAllForPersona(resource, persona);
        this.resourceService.addRoleToPersona(resource, persona, role);
        return membership;
    }

    @Override
    public void remove(OrganizationMembership organizationMembership) {
        this.remove(organizationMembership.getIdAsUUID());
    }

    @Override
    public void remove(UUID id) {
        this.session.execute((Statement)((BoundStatement)this.stmtRemoveInstance.get()).setUUID("id", id));
    }

    @Override
    OrganizationMembership getFromRow(Row row) {
        Organization organization = this.organizationService.getById(row.getUUID("organization"));
        Persona member = this.personaService.getById(row.getUUID("member"));
        Role role = this.roleService.getById(row.getUUID("role"));
        OrganizationMembership.Builder builder = new OrganizationMembership.Builder();
        this.mapBaseFields(row, builder);
        return builder.organization(organization).member(member).role(role).build();
    }
}

