/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.JoinRequestStatus;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Persona;

public class OrganizationJoinRequest
extends BaseEntity {
    private Organization organization;
    private Persona persona;
    private JoinRequestStatus status;

    public OrganizationJoinRequest(Organization organization, Persona persona, JoinRequestStatus status) {
        this.organization = organization;
        this.persona = persona;
        this.status = status;
    }

    public OrganizationJoinRequest(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, Organization organization, Persona persona, JoinRequestStatus status) {
        super(id, createdAt, updatedAt);
        this.organization = organization;
        this.persona = persona;
        this.status = status;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Persona getPersona() {
        return this.persona;
    }

    public JoinRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(JoinRequestStatus status) {
        this.status = status;
    }

    public static class Builder
    extends BaseEntity.Builder {
        private Organization organization;
        private Persona persona;
        private JoinRequestStatus status;

        public Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public Builder persona(Persona persona) {
            this.persona = persona;
            return this;
        }

        public Builder status(JoinRequestStatus status) {
            this.status = status;
            return this;
        }

        public OrganizationJoinRequest build() {
            return new OrganizationJoinRequest(this.id, this.createdAt, this.updatedAt, this.organization, this.persona, this.status);
        }
    }
}

