/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKACC")
@ValidIdRange(min=100000, max=109999)
public interface MsgLogger {
    public static final MsgLogger LOGGER = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)MsgLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=100000, value="Could not process prepare query: [%s]")
    public void couldNotPrepareQuery(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=100001, value="Failed to initialize Cassandra's schema for Accounts. Reason")
    public void failedToInitializeSchema(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=100002, value="Shutting down Cassandra driver for Accounts")
    public void shuttingDownCassandraDriver();

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=100003, value="Failed to properly shutdown the Cassandra driver for Accounts. Reason")
    public void failedToShutdownDriver(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=100004, value="Organization [%s] created. ID: [%s]")
    public void organizationCreated(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=100005, value="Join request from [%s] to join organization [%s] created. ID: [%s]")
    public void joinRequestCreated(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=100006, value="There's an incoming request for an non-secure location, but a component has requested information about the current persona. This probably indicates a mismatch in the integration of the component. Either the component should accept non-secure requests and not ask for a Persona, or should only accept secure requests. Hawkular Accounts is returning NULL to the component. Lookout for NullPointerExceptions!")
    public void nonAuthRequestWantsPersona();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100007, value="Invitation [%s] created.")
    public void invitationCreated(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100008, value="Invitation [%s] accepted.")
    public void invitationAccepted(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100009, value="Invitation [%s] removed.")
    public void invitationRemoved(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100010, value="Invitation [%s] dispatched.")
    public void invitationDispatched(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100011, value="There's already an operation with the name [%s].")
    public void duplicateOperation(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100012, value="Operation [%s] created.")
    public void operationCreated(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=100013, value="Operation [%s] has been changed. Persisting new data.")
    public void operationHasChanged(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100014, value="Join Request [%s] accepted.")
    public void joinRequestAccepted(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100015, value="Join Request [%s] rejected.")
    public void joinRequestRejected(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100016, value="Join Request [%s] removed.")
    public void joinRequestRemoved(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100017, value="Organization membership [%s] created.")
    public void organizationMembershipCreated(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100018, value="Organization membership [%s] has its role changed to [%s].")
    public void organizationMembershipRoleChanged(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100019, value="Persona [%s] is a member of [%d] organizations.")
    public void organizationsPersonaJoined(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100020, value="Persona [%s] can join [%d] organizations.")
    public void organizationsPersonaToJoin(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100021, value="Persona [%s] has [%d] join requests.")
    public void personaJoinRequests(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100022, value="Persona [%s] has [%d] pending join requests.")
    public void personaJoinRequestsPending(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100023, value="Persona [%s] can join [%d] organizations, removing the ones that are pending a decision.")
    public void organizationsPersonaToJoinFiltered(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100024, value="Starting removal of organization [%s]")
    public void startingRemovalOfOrganization(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100025, value="Finished removal of organization [%s]")
    public void finishedRemovalOfOrganization(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100026, value="Starting transfer of organization [%s] from [%s] to [%s]")
    public void startingTransferOfOrganization(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100027, value="Finished transfer of organization [%s] from [%s] to [%s]")
    public void finishedTransferOfOrganization(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100028, value="Checking if the persona [%s] has permission to perform [%s] on resource [%s]")
    public void checkPermission(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100029, value="The resource [%s] has no explicit owner. Checking the parent's: [%s]")
    public void checkingParentsPermission(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100030, value="Permission to perform [%s] on resource [%s] to persona [%s] granted because the persona is the owner of the resource.")
    public void permissionGrantedToOwner(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100031, value="The operation [%s] can be performed by personas in [%d] different roles.")
    public void operationPermittedToRoles(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100032, value="The persona [%s] has [%d] different roles.")
    public void personaHasRoles(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100033, value="Result of check if the persona [%s] has permission to perform [%s] on resource [%s]: [%b]")
    public void checkPermissionResult(String var1, String var2, String var3, boolean var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100034, value="Permission [%s] created for operation [%s] with role [%s]")
    public void permissionCreated(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100035, value="Permission [%s] removed for operation [%s] with role [%s]")
    public void permissionRemoved(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100036, value="Created link between persona [%s], resource [%s] and role [%s].")
    public void personaResourceRoleCreated(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100037, value="PersonaResourceRole ID [%s] removed.")
    public void personaResourceRoleRemoved(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100038, value="Removed link between persona [%s], resource [%s] and role [%s].")
    public void personaResourceRoleRemoved(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100039, value="Determining effective roles for persona [%s] on resource [%s].")
    public void determiningEffectiveRolesForPersonaOnResource(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100040, value="Persona [%s] on resource [%s]: [%d] roles.")
    public void numOfDirectRolesOnResource(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100041, value="Persona [%s] on resource [%s] has no direct roles. Checking indirect roles.")
    public void noDirectRolesOnResource(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100042, value="Checking roles for persona [%s] on resource [%s] via organization [%s]")
    public void checkingIndirectRolesViaOrganization(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100043, value="Persona [%s] on resource [%s] via organization [%s]: [%d] roles.")
    public void numOfEffectiveRolesViaOrganization(String var1, String var2, String var3, int var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100044, value="Total of roles for persona [%s] on resource [%s]: [%d] roles.")
    public void totalEffectiveRolesOnResource(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100045, value="Total of roles (including implicit) for persona [%s] on resource [%s]: [%d] roles.")
    public void totalEffectiveRolesOnResourceWithImplicitRoles(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100046, value="The provided resource ID [%s] isn't an UUID. Derived UUID from the ID: [%s].")
    public void resourceIdIsntUUID(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100047, value="Resource [%s] created.")
    public void resourceCreated(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100048, value="Resource [%s] is being created with persona [%s] as owner.")
    public void resourceBeingCreatedWithPersona(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100049, value="Resource [%s] is being created with resource [%s] as parent.")
    public void resourceBeingCreatedWithParent(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100050, value="Resource [%s] removed.")
    public void resourceRemoved(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100051, value="Resource [%s] being transferred from persona [%s] to persona [%s].")
    public void resourceTransferring(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100052, value="Resource [%s] being transferred to persona [%s]. The resource had no owner before.")
    public void resourceTransferringNoOwner(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100053, value="Revoking all permissions on resource [%s] for persona [%s]")
    public void revokingAllForPersona(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100054, value="Persona [%s] already has role [%s] on resource [%s]. Will return the existing record instead of creating a new one.")
    public void personaAlreadyHaveRoleOnResource(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100055, value="Role [%s] created.")
    public void roleCreated(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100056, value="User [%s] had its name changed. New name: [%s], old name: [%s].")
    public void settingUsersName(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100057, value="User [%s] had its email changed. New email: [%s], old email: [%s].")
    public void settingUsersEmail(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100058, value="User [%s] is not yet known to Accounts. Creating.")
    public void creatingUser(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100059, value="User [%s], name [%s], is not yet known to Accounts. Creating.")
    public void creatingUserWithName(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=100060, value="Listing all users known to Accounts. This should not happen in production code, only in test code.")
    public void listingAllUsers();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100061, value="Creating user settings for user [%s].")
    public void creatingSettings(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100062, value="Storing user setting for user [%s] named [%s] with value [%s].")
    public void storedSetting(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=100063, value="Removed user setting for user [%s] named [%s].")
    public void removedSetting(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=100064, value="Cassandra session acquired.")
    public void cassandraSessionAcquired();
}

